/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.StaticIp;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StaticIpMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddress").isBinary(false).build();
    private static final MarshallingInfo<String> ATTACHEDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachedTo").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISATTACHED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isAttached").isBinary(false).build();
    private static final StaticIpMarshaller INSTANCE = new StaticIpMarshaller();

    private StaticIpMarshaller() {
    }

    public static StaticIpMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StaticIp staticIp, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)staticIp, (String)"staticIp");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)staticIp.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)staticIp.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)staticIp.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)staticIp.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)staticIp.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)staticIp.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)staticIp.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)staticIp.attachedTo(), ATTACHEDTO_BINDING);
            protocolMarshaller.marshall((Object)staticIp.isAttached(), ISATTACHED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

