/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.LoadBalancer;
import software.amazon.awssdk.services.lightsail.transform.InstanceHealthSummaryUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.LoadBalancerTlsCertificateSummaryUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationUnmarshaller;

public class LoadBalancerUnmarshaller
implements Unmarshaller<LoadBalancer, JsonUnmarshallerContext> {
    private static final LoadBalancerUnmarshaller INSTANCE = new LoadBalancerUnmarshaller();

    public LoadBalancer unmarshall(JsonUnmarshallerContext context) throws Exception {
        LoadBalancer.Builder loadBalancerBuilder = LoadBalancer.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.supportCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("dnsName", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.dnsName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("protocol", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.protocol((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("publicPorts", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.publicPorts(new ListUnmarshaller(context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("healthCheckPath", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.healthCheckPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("instancePort", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.instancePort((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("instanceHealthSummary", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.instanceHealthSummary(new ListUnmarshaller((Unmarshaller)InstanceHealthSummaryUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("tlsCertificateSummaries", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.tlsCertificateSummaries(new ListUnmarshaller((Unmarshaller)LoadBalancerTlsCertificateSummaryUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("configurationOptions", targetDepth)) {
                    context.nextToken();
                    loadBalancerBuilder.configurationOptionsWithStrings(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LoadBalancer)loadBalancerBuilder.build();
    }

    public static LoadBalancerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

