/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceHealthSummaryMarshaller {
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEHEALTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceHealth").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEHEALTHREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceHealthReason").isBinary(false).build();
    private static final InstanceHealthSummaryMarshaller INSTANCE = new InstanceHealthSummaryMarshaller();

    private InstanceHealthSummaryMarshaller() {
    }

    public static InstanceHealthSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceHealthSummary instanceHealthSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceHealthSummary, (String)"instanceHealthSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceHealthSummary.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)instanceHealthSummary.instanceHealthAsString(), INSTANCEHEALTH_BINDING);
            protocolMarshaller.marshall((Object)instanceHealthSummary.instanceHealthReasonAsString(), INSTANCEHEALTHREASON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

