/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportKeyPairRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYPAIRNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyPairName").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICKEYBASE64_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicKeyBase64").isBinary(false).build();
    private static final ImportKeyPairRequestModelMarshaller INSTANCE = new ImportKeyPairRequestModelMarshaller();

    private ImportKeyPairRequestModelMarshaller() {
    }

    public static ImportKeyPairRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportKeyPairRequest importKeyPairRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)importKeyPairRequest), (String)"importKeyPairRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importKeyPairRequest.keyPairName(), KEYPAIRNAME_BINDING);
            protocolMarshaller.marshall((Object)importKeyPairRequest.publicKeyBase64(), PUBLICKEYBASE64_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

