/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetInstanceMetricDataRequestModelMarshaller {
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").isBinary(false).build();
    private static final MarshallingInfo<Integer> PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("period").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unit").isBinary(false).build();
    private static final MarshallingInfo<List> STATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statistics").isBinary(false).build();
    private static final GetInstanceMetricDataRequestModelMarshaller INSTANCE = new GetInstanceMetricDataRequestModelMarshaller();

    private GetInstanceMetricDataRequestModelMarshaller() {
    }

    public static GetInstanceMetricDataRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetInstanceMetricDataRequest getInstanceMetricDataRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getInstanceMetricDataRequest), (String)"getInstanceMetricDataRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getInstanceMetricDataRequest.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)getInstanceMetricDataRequest.metricNameAsString(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)getInstanceMetricDataRequest.period(), PERIOD_BINDING);
            protocolMarshaller.marshall((Object)getInstanceMetricDataRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)getInstanceMetricDataRequest.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)getInstanceMetricDataRequest.unitAsString(), UNIT_BINDING);
            protocolMarshaller.marshall(getInstanceMetricDataRequest.statisticsAsStrings(), STATISTICS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

