/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.DomainEntry;

public class DomainEntryUnmarshaller
implements Unmarshaller<DomainEntry, JsonUnmarshallerContext> {
    private static final DomainEntryUnmarshaller INSTANCE = new DomainEntryUnmarshaller();

    public DomainEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        DomainEntry.Builder domainEntryBuilder = DomainEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    domainEntryBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    domainEntryBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("target", targetDepth)) {
                    context.nextToken();
                    domainEntryBuilder.target((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("isAlias", targetDepth)) {
                    context.nextToken();
                    domainEntryBuilder.isAlias((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    domainEntryBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("options", targetDepth)) {
                    context.nextToken();
                    domainEntryBuilder.options(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DomainEntry)domainEntryBuilder.build();
    }

    public static DomainEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

