/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.Bundle;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BundleMarshaller {
    private static final MarshallingInfo<Float> PRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("price").isBinary(false).build();
    private static final MarshallingInfo<Integer> CPUCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpuCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> DISKSIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diskSizeInGb").isBinary(false).build();
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isActive").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Integer> POWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("power").isBinary(false).build();
    private static final MarshallingInfo<Float> RAMSIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ramSizeInGb").isBinary(false).build();
    private static final MarshallingInfo<Integer> TRANSFERPERMONTHINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferPerMonthInGb").isBinary(false).build();
    private static final MarshallingInfo<List> SUPPORTEDPLATFORMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedPlatforms").isBinary(false).build();
    private static final BundleMarshaller INSTANCE = new BundleMarshaller();

    private BundleMarshaller() {
    }

    public static BundleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Bundle bundle, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)bundle, (String)"bundle");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)bundle.price(), PRICE_BINDING);
            protocolMarshaller.marshall((Object)bundle.cpuCount(), CPUCOUNT_BINDING);
            protocolMarshaller.marshall((Object)bundle.diskSizeInGb(), DISKSIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)bundle.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)bundle.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)bundle.isActive(), ISACTIVE_BINDING);
            protocolMarshaller.marshall((Object)bundle.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)bundle.power(), POWER_BINDING);
            protocolMarshaller.marshall((Object)bundle.ramSizeInGb(), RAMSIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)bundle.transferPerMonthInGb(), TRANSFERPERMONTHINGB_BINDING);
            protocolMarshaller.marshall(bundle.supportedPlatformsAsStrings(), SUPPORTEDPLATFORMS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

