/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceHealthReason;
import software.amazon.awssdk.services.lightsail.model.InstanceHealthState;
import software.amazon.awssdk.services.lightsail.transform.InstanceHealthSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceHealthSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceHealthSummary> {
    private final String instanceName;
    private final String instanceHealth;
    private final String instanceHealthReason;

    private InstanceHealthSummary(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.instanceHealth = builder.instanceHealth;
        this.instanceHealthReason = builder.instanceHealthReason;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public InstanceHealthState instanceHealth() {
        return InstanceHealthState.fromValue(this.instanceHealth);
    }

    public String instanceHealthAsString() {
        return this.instanceHealth;
    }

    public InstanceHealthReason instanceHealthReason() {
        return InstanceHealthReason.fromValue(this.instanceHealthReason);
    }

    public String instanceHealthReasonAsString() {
        return this.instanceHealthReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceHealthReasonAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHealthSummary)) {
            return false;
        }
        InstanceHealthSummary other = (InstanceHealthSummary)obj;
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.instanceHealthAsString(), other.instanceHealthAsString()) && Objects.equals(this.instanceHealthReasonAsString(), other.instanceHealthReasonAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceHealthSummary").add("InstanceName", (Object)this.instanceName()).add("InstanceHealth", (Object)this.instanceHealthAsString()).add("InstanceHealthReason", (Object)this.instanceHealthReasonAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "instanceHealth": {
                return Optional.ofNullable(clazz.cast(this.instanceHealthAsString()));
            }
            case "instanceHealthReason": {
                return Optional.ofNullable(clazz.cast(this.instanceHealthReasonAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceHealthSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String instanceHealth;
        private String instanceHealthReason;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHealthSummary model) {
            this.instanceName(model.instanceName);
            this.instanceHealth(model.instanceHealth);
            this.instanceHealthReason(model.instanceHealthReason);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getInstanceHealth() {
            return this.instanceHealth;
        }

        @Override
        public final Builder instanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
            return this;
        }

        @Override
        public final Builder instanceHealth(InstanceHealthState instanceHealth) {
            this.instanceHealth(instanceHealth.toString());
            return this;
        }

        public final void setInstanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
        }

        public final String getInstanceHealthReason() {
            return this.instanceHealthReason;
        }

        @Override
        public final Builder instanceHealthReason(String instanceHealthReason) {
            this.instanceHealthReason = instanceHealthReason;
            return this;
        }

        @Override
        public final Builder instanceHealthReason(InstanceHealthReason instanceHealthReason) {
            this.instanceHealthReason(instanceHealthReason.toString());
            return this;
        }

        public final void setInstanceHealthReason(String instanceHealthReason) {
            this.instanceHealthReason = instanceHealthReason;
        }

        public InstanceHealthSummary build() {
            return new InstanceHealthSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceHealthSummary> {
        public Builder instanceName(String var1);

        public Builder instanceHealth(String var1);

        public Builder instanceHealth(InstanceHealthState var1);

        public Builder instanceHealthReason(String var1);

        public Builder instanceHealthReason(InstanceHealthReason var1);
    }
}

