/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.DomainEntryOptionsCopier;
import software.amazon.awssdk.services.lightsail.transform.DomainEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainEntry> {
    private final String id;
    private final String name;
    private final String target;
    private final Boolean isAlias;
    private final String type;
    private final Map<String, String> options;

    private DomainEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.target = builder.target;
        this.isAlias = builder.isAlias;
        this.type = builder.type;
        this.options = builder.options;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String target() {
        return this.target;
    }

    public Boolean isAlias() {
        return this.isAlias;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEntry)) {
            return false;
        }
        DomainEntry other = (DomainEntry)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.isAlias(), other.isAlias()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"DomainEntry").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Target", (Object)this.target()).add("IsAlias", (Object)this.isAlias()).add("Type", (Object)this.type()).add("Options", this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "isAlias": {
                return Optional.ofNullable(clazz.cast(this.isAlias()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String target;
        private Boolean isAlias;
        private String type;
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEntry model) {
            this.id(model.id);
            this.name(model.name);
            this.target(model.target);
            this.isAlias(model.isAlias);
            this.type(model.type);
            this.options(model.options);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Boolean getIsAlias() {
            return this.isAlias;
        }

        @Override
        public final Builder isAlias(Boolean isAlias) {
            this.isAlias = isAlias;
            return this;
        }

        public final void setIsAlias(Boolean isAlias) {
            this.isAlias = isAlias;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
        }

        public DomainEntry build() {
            return new DomainEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainEntry> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder target(String var1);

        public Builder isAlias(Boolean var1);

        public Builder type(String var1);

        public Builder options(Map<String, String> var1);
    }
}

