/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.lightsail.model.KeyPair;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyPairResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, CreateKeyPairResponse> {
    private final KeyPair keyPair;
    private final String publicKeyBase64;
    private final String privateKeyBase64;
    private final Operation operation;

    private CreateKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.keyPair = builder.keyPair;
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
        this.operation = builder.operation;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public String publicKeyBase64() {
        return this.publicKeyBase64;
    }

    public String privateKeyBase64() {
        return this.privateKeyBase64;
    }

    public Operation operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairResponse)) {
            return false;
        }
        CreateKeyPairResponse other = (CreateKeyPairResponse)((Object)obj);
        return Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.publicKeyBase64(), other.publicKeyBase64()) && Objects.equals(this.privateKeyBase64(), other.privateKeyBase64()) && Objects.equals(this.operation(), other.operation());
    }

    public String toString() {
        return ToString.builder((String)"CreateKeyPairResponse").add("KeyPair", (Object)this.keyPair()).add("PublicKeyBase64", (Object)this.publicKeyBase64()).add("PrivateKeyBase64", (Object)this.privateKeyBase64()).add("Operation", (Object)this.operation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
            case "publicKeyBase64": {
                return Optional.ofNullable(clazz.cast(this.publicKeyBase64()));
            }
            case "privateKeyBase64": {
                return Optional.ofNullable(clazz.cast(this.privateKeyBase64()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private KeyPair keyPair;
        private String publicKeyBase64;
        private String privateKeyBase64;
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairResponse model) {
            super(model);
            this.keyPair(model.keyPair);
            this.publicKeyBase64(model.publicKeyBase64);
            this.privateKeyBase64(model.privateKeyBase64);
            this.operation(model.operation);
        }

        public final KeyPair.Builder getKeyPair() {
            return this.keyPair != null ? this.keyPair.toBuilder() : null;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        public final String getPublicKeyBase64() {
            return this.publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        public final String getPrivateKeyBase64() {
            return this.privateKeyBase64;
        }

        @Override
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        public final Operation.Builder getOperation() {
            return this.operation != null ? this.operation.toBuilder() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public CreateKeyPairResponse build() {
            return new CreateKeyPairResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, CreateKeyPairResponse> {
        public Builder keyPair(KeyPair var1);

        default public Builder keyPair(Consumer<KeyPair.Builder> keyPair) {
            return this.keyPair((KeyPair)((KeyPair.Builder)KeyPair.builder().applyMutation(keyPair)).build());
        }

        public Builder publicKeyBase64(String var1);

        public Builder privateKeyBase64(String var1);

        public Builder operation(Operation var1);

        default public Builder operation(Consumer<Operation.Builder> operation) {
            return this.operation((Operation)((Operation.Builder)Operation.builder().applyMutation(operation)).build());
        }
    }
}

