/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshot;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationUnmarshaller;

public class DiskSnapshotUnmarshaller
implements Unmarshaller<DiskSnapshot, JsonUnmarshallerContext> {
    private static final DiskSnapshotUnmarshaller INSTANCE = new DiskSnapshotUnmarshaller();

    public DiskSnapshot unmarshall(JsonUnmarshallerContext context) throws Exception {
        DiskSnapshot.Builder diskSnapshotBuilder = DiskSnapshot.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.supportCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sizeInGb", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.sizeInGb((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("progress", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.progress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fromDiskName", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.fromDiskName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fromDiskArn", targetDepth)) {
                    context.nextToken();
                    diskSnapshotBuilder.fromDiskArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DiskSnapshot)diskSnapshotBuilder.build();
    }

    public static DiskSnapshotUnmarshaller getInstance() {
        return INSTANCE;
    }
}

