/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.Bundle;

public class BundleUnmarshaller
implements Unmarshaller<Bundle, JsonUnmarshallerContext> {
    private static final BundleUnmarshaller INSTANCE = new BundleUnmarshaller();

    public Bundle unmarshall(JsonUnmarshallerContext context) throws Exception {
        Bundle.Builder bundleBuilder = Bundle.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("price", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.price((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("cpuCount", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.cpuCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("diskSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.diskSizeInGb((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("bundleId", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.bundleId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("isActive", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.isActive((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("power", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.power((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ramSizeInGb", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.ramSizeInGb((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("transferPerMonthInGb", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.transferPerMonthInGb((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("supportedPlatforms", targetDepth)) {
                    context.nextToken();
                    bundleBuilder.supportedPlatformsWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Bundle)bundleBuilder.build();
    }

    public static BundleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

