/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.PortInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenInstancePublicPortsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, OpenInstancePublicPortsRequest> {
    private final PortInfo portInfo;
    private final String instanceName;

    private OpenInstancePublicPortsRequest(BuilderImpl builder) {
        super(builder);
        this.portInfo = builder.portInfo;
        this.instanceName = builder.instanceName;
    }

    public PortInfo portInfo() {
        return this.portInfo;
    }

    public String instanceName() {
        return this.instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenInstancePublicPortsRequest)) {
            return false;
        }
        OpenInstancePublicPortsRequest other = (OpenInstancePublicPortsRequest)((Object)obj);
        return Objects.equals(this.portInfo(), other.portInfo()) && Objects.equals(this.instanceName(), other.instanceName());
    }

    public String toString() {
        return ToString.builder((String)"OpenInstancePublicPortsRequest").add("PortInfo", (Object)this.portInfo()).add("InstanceName", (Object)this.instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portInfo": {
                return Optional.ofNullable(clazz.cast(this.portInfo()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private PortInfo portInfo;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenInstancePublicPortsRequest model) {
            super(model);
            this.portInfo(model.portInfo);
            this.instanceName(model.instanceName);
        }

        public final PortInfo.Builder getPortInfo() {
            return this.portInfo != null ? this.portInfo.toBuilder() : null;
        }

        @Override
        public final Builder portInfo(PortInfo portInfo) {
            this.portInfo = portInfo;
            return this;
        }

        public final void setPortInfo(PortInfo.BuilderImpl portInfo) {
            this.portInfo = portInfo != null ? portInfo.build() : null;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OpenInstancePublicPortsRequest build() {
            return new OpenInstancePublicPortsRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, OpenInstancePublicPortsRequest> {
        public Builder portInfo(PortInfo var1);

        default public Builder portInfo(Consumer<PortInfo.Builder> portInfo) {
            return this.portInfo((PortInfo)((PortInfo.Builder)PortInfo.builder().applyMutation(portInfo)).build());
        }

        public Builder instanceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

