/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstancesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, CreateInstancesResponse> {
    private final List<Operation> operations;

    private CreateInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesResponse)) {
            return false;
        }
        CreateInstancesResponse other = (CreateInstancesResponse)((Object)obj);
        return Objects.equals(this.operations(), other.operations());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstancesResponse").add("Operations", this.operations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<Operation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesResponse model) {
            super(model);
            this.operations(model.operations);
        }

        public final Collection<Operation.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<Operation.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (Operation)((Operation.Builder)Operation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        @Override
        public CreateInstancesResponse build() {
            return new CreateInstancesResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, CreateInstancesResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);

        public Builder operations(Consumer<Operation.Builder> ... var1);
    }
}

