/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstancePortInfoMarshaller {
    private static final MarshallingInfo<Integer> FROMPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromPort").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("toPort").isBinary(false).build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").isBinary(false).build();
    private static final MarshallingInfo<String> ACCESSFROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessFrom").isBinary(false).build();
    private static final MarshallingInfo<String> ACCESSTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessType").isBinary(false).build();
    private static final MarshallingInfo<String> COMMONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("commonName").isBinary(false).build();
    private static final MarshallingInfo<String> ACCESSDIRECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessDirection").isBinary(false).build();
    private static final InstancePortInfoMarshaller INSTANCE = new InstancePortInfoMarshaller();

    private InstancePortInfoMarshaller() {
    }

    public static InstancePortInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstancePortInfo instancePortInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instancePortInfo, (String)"instancePortInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instancePortInfo.fromPort(), FROMPORT_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.toPort(), TOPORT_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.protocolAsString(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.accessFrom(), ACCESSFROM_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.accessTypeAsString(), ACCESSTYPE_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.commonName(), COMMONNAME_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.accessDirectionAsString(), ACCESSDIRECTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

