/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.NetworkProtocol;
import software.amazon.awssdk.services.lightsail.transform.PortInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PortInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, PortInfo> {
    private final Integer fromPort;
    private final Integer toPort;
    private final String protocol;

    private PortInfo(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortInfo)) {
            return false;
        }
        PortInfo other = (PortInfo)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public String toString() {
        return ToString.builder((String)"PortInfo").add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromPort": {
                return Optional.of(clazz.cast(this.fromPort()));
            }
            case "toPort": {
                return Optional.of(clazz.cast(this.toPort()));
            }
            case "protocol": {
                return Optional.of(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(PortInfo model) {
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.protocol(model.protocol);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public PortInfo build() {
            return new PortInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PortInfo> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(NetworkProtocol var1);
    }
}

