/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.Disk;
import software.amazon.awssdk.services.lightsail.model.DiskListCopier;
import software.amazon.awssdk.services.lightsail.transform.InstanceHardwareMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceHardware
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceHardware> {
    private final Integer cpuCount;
    private final List<Disk> disks;
    private final Float ramSizeInGb;

    private InstanceHardware(BuilderImpl builder) {
        this.cpuCount = builder.cpuCount;
        this.disks = builder.disks;
        this.ramSizeInGb = builder.ramSizeInGb;
    }

    public Integer cpuCount() {
        return this.cpuCount;
    }

    public List<Disk> disks() {
        return this.disks;
    }

    public Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.disks());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramSizeInGb());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHardware)) {
            return false;
        }
        InstanceHardware other = (InstanceHardware)obj;
        return Objects.equals(this.cpuCount(), other.cpuCount()) && Objects.equals(this.disks(), other.disks()) && Objects.equals(this.ramSizeInGb(), other.ramSizeInGb());
    }

    public String toString() {
        return ToString.builder((String)"InstanceHardware").add("CpuCount", (Object)this.cpuCount()).add("Disks", this.disks()).add("RamSizeInGb", (Object)this.ramSizeInGb()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpuCount": {
                return Optional.of(clazz.cast(this.cpuCount()));
            }
            case "disks": {
                return Optional.of(clazz.cast(this.disks()));
            }
            case "ramSizeInGb": {
                return Optional.of(clazz.cast(this.ramSizeInGb()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceHardwareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cpuCount;
        private List<Disk> disks;
        private Float ramSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHardware model) {
            this.cpuCount(model.cpuCount);
            this.disks(model.disks);
            this.ramSizeInGb(model.ramSizeInGb);
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Collection<Disk.Builder> getDisks() {
            return this.disks != null ? (Collection)this.disks.stream().map(Disk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DiskListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk ... disks) {
            this.disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Consumer<Disk.Builder> ... disks) {
            this.disks(Stream.of(disks).map(c -> (Disk)((Disk.Builder)Disk.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDisks(Collection<Disk.BuilderImpl> disks) {
            this.disks = DiskListCopier.copyFromBuilder(disks);
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public InstanceHardware build() {
            return new InstanceHardware(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceHardware> {
        public Builder cpuCount(Integer var1);

        public Builder disks(Collection<Disk> var1);

        public Builder disks(Disk ... var1);

        public Builder disks(Consumer<Disk.Builder> ... var1);

        public Builder ramSizeInGb(Float var1);
    }
}

