/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceAccessDetailsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetInstanceAccessDetailsRequest> {
    private final String instanceName;
    private final String protocol;

    private GetInstanceAccessDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.protocol = builder.protocol;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public InstanceAccessProtocol protocol() {
        return InstanceAccessProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessDetailsRequest)) {
            return false;
        }
        GetInstanceAccessDetailsRequest other = (GetInstanceAccessDetailsRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetInstanceAccessDetailsRequest").add("InstanceName", (Object)this.instanceName()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "protocol": {
                return Optional.of(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessDetailsRequest model) {
            super(model);
            this.instanceName(model.instanceName);
            this.protocol(model.protocol);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceAccessDetailsRequest build() {
            return new GetInstanceAccessDetailsRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, GetInstanceAccessDetailsRequest> {
        public Builder instanceName(String var1);

        public Builder protocol(String var1);

        public Builder protocol(InstanceAccessProtocol var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

