/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.StaticIp;

@SdkInternalApi
public class StaticIpMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddress").build();
    private static final MarshallingInfo<String> ATTACHEDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachedTo").build();
    private static final MarshallingInfo<Boolean> ISATTACHED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isAttached").build();
    private static final StaticIpMarshaller instance = new StaticIpMarshaller();

    public static StaticIpMarshaller getInstance() {
        return instance;
    }

    public void marshall(StaticIp staticIp, ProtocolMarshaller protocolMarshaller) {
        if (staticIp == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)staticIp.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)staticIp.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)staticIp.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)staticIp.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)staticIp.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)staticIp.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)staticIp.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)staticIp.attachedTo(), ATTACHEDTO_BINDING);
            protocolMarshaller.marshall((Object)staticIp.isAttached(), ISATTACHED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

