/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfo;

@SdkInternalApi
public class InstancePortInfoMarshaller {
    private static final MarshallingInfo<Integer> FROMPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromPort").build();
    private static final MarshallingInfo<Integer> TOPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("toPort").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final MarshallingInfo<String> ACCESSFROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessFrom").build();
    private static final MarshallingInfo<String> ACCESSTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessType").build();
    private static final MarshallingInfo<String> COMMONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("commonName").build();
    private static final MarshallingInfo<String> ACCESSDIRECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessDirection").build();
    private static final InstancePortInfoMarshaller instance = new InstancePortInfoMarshaller();

    public static InstancePortInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstancePortInfo instancePortInfo, ProtocolMarshaller protocolMarshaller) {
        if (instancePortInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instancePortInfo.fromPort(), FROMPORT_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.toPort(), TOPORT_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.protocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.accessFrom(), ACCESSFROM_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.accessType(), ACCESSTYPE_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.commonName(), COMMONNAME_BINDING);
            protocolMarshaller.marshall((Object)instancePortInfo.accessDirection(), ACCESSDIRECTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

