/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.services.lightsail.transform.MetricDatapointMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricDatapoint
implements StructuredPojo,
ToCopyableBuilder<Builder, MetricDatapoint> {
    private final Double average;
    private final Double maximum;
    private final Double minimum;
    private final Double sampleCount;
    private final Double sum;
    private final Date timestamp;
    private final String unit;

    private MetricDatapoint(BuilderImpl builder) {
        this.average = builder.average;
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.timestamp = builder.timestamp;
        this.unit = builder.unit;
    }

    public Double average() {
        return this.average;
    }

    public Double maximum() {
        return this.maximum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Double sampleCount() {
        return this.sampleCount;
    }

    public Double sum() {
        return this.sum;
    }

    public Date timestamp() {
        return this.timestamp;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.average() == null ? 0 : this.average().hashCode());
        hashCode = 31 * hashCode + (this.maximum() == null ? 0 : this.maximum().hashCode());
        hashCode = 31 * hashCode + (this.minimum() == null ? 0 : this.minimum().hashCode());
        hashCode = 31 * hashCode + (this.sampleCount() == null ? 0 : this.sampleCount().hashCode());
        hashCode = 31 * hashCode + (this.sum() == null ? 0 : this.sum().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatapoint)) {
            return false;
        }
        MetricDatapoint other = (MetricDatapoint)obj;
        if (other.average() == null ^ this.average() == null) {
            return false;
        }
        if (other.average() != null && !other.average().equals(this.average())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        if (other.maximum() != null && !other.maximum().equals(this.maximum())) {
            return false;
        }
        if (other.minimum() == null ^ this.minimum() == null) {
            return false;
        }
        if (other.minimum() != null && !other.minimum().equals(this.minimum())) {
            return false;
        }
        if (other.sampleCount() == null ^ this.sampleCount() == null) {
            return false;
        }
        if (other.sampleCount() != null && !other.sampleCount().equals(this.sampleCount())) {
            return false;
        }
        if (other.sum() == null ^ this.sum() == null) {
            return false;
        }
        if (other.sum() != null && !other.sum().equals(this.sum())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        return other.unit() == null || other.unit().equals(this.unit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.average() != null) {
            sb.append("Average: ").append(this.average()).append(",");
        }
        if (this.maximum() != null) {
            sb.append("Maximum: ").append(this.maximum()).append(",");
        }
        if (this.minimum() != null) {
            sb.append("Minimum: ").append(this.minimum()).append(",");
        }
        if (this.sampleCount() != null) {
            sb.append("SampleCount: ").append(this.sampleCount()).append(",");
        }
        if (this.sum() != null) {
            sb.append("Sum: ").append(this.sum()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricDatapointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Double average;
        private Double maximum;
        private Double minimum;
        private Double sampleCount;
        private Double sum;
        private Date timestamp;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatapoint model) {
            this.setAverage(model.average);
            this.setMaximum(model.maximum);
            this.setMinimum(model.minimum);
            this.setSampleCount(model.sampleCount);
            this.setSum(model.sum);
            this.setTimestamp(model.timestamp);
            this.setUnit(model.unit);
        }

        public final Double getAverage() {
            return this.average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy((Date)timestamp);
            return this;
        }

        public final void setTimestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy((Date)timestamp);
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(MetricUnit unit) {
            this.unit(unit.toString());
        }

        public MetricDatapoint build() {
            return new MetricDatapoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricDatapoint> {
        public Builder average(Double var1);

        public Builder maximum(Double var1);

        public Builder minimum(Double var1);

        public Builder sampleCount(Double var1);

        public Builder sum(Double var1);

        public Builder timestamp(Date var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);
    }
}

