/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceSettingsResponse extends LicenseManagerLinuxSubscriptionsResponse implements
        ToCopyableBuilder<UpdateServiceSettingsResponse.Builder, UpdateServiceSettingsResponse> {
    private static final SdkField<List<String>> HOME_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HomeRegions")
            .getter(getter(UpdateServiceSettingsResponse::homeRegions))
            .setter(setter(Builder::homeRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LinuxSubscriptionsDiscovery")
            .getter(getter(UpdateServiceSettingsResponse::linuxSubscriptionsDiscoveryAsString))
            .setter(setter(Builder::linuxSubscriptionsDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinuxSubscriptionsDiscovery")
                    .build()).build();

    private static final SdkField<LinuxSubscriptionsDiscoverySettings> LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD = SdkField
            .<LinuxSubscriptionsDiscoverySettings> builder(MarshallingType.SDK_POJO)
            .memberName("LinuxSubscriptionsDiscoverySettings")
            .getter(getter(UpdateServiceSettingsResponse::linuxSubscriptionsDiscoverySettings))
            .setter(setter(Builder::linuxSubscriptionsDiscoverySettings))
            .constructor(LinuxSubscriptionsDiscoverySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LinuxSubscriptionsDiscoverySettings").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateServiceSettingsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> STATUS_MESSAGE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("StatusMessage")
            .getter(getter(UpdateServiceSettingsResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HOME_REGIONS_FIELD, LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD, LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD,
                    STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> homeRegions;

    private final String linuxSubscriptionsDiscovery;

    private final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;

    private final String status;

    private final Map<String, String> statusMessage;

    private UpdateServiceSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.homeRegions = builder.homeRegions;
        this.linuxSubscriptionsDiscovery = builder.linuxSubscriptionsDiscovery;
        this.linuxSubscriptionsDiscoverySettings = builder.linuxSubscriptionsDiscoverySettings;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the HomeRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHomeRegions() {
        return homeRegions != null && !(homeRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Region in which License Manager displays the aggregated data for Linux subscriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHomeRegions} method.
     * </p>
     * 
     * @return The Region in which License Manager displays the aggregated data for Linux subscriptions.
     */
    public final List<String> homeRegions() {
        return homeRegions;
    }

    /**
     * <p>
     * Lists if discovery has been enabled for Linux subscriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #linuxSubscriptionsDiscovery} will return {@link LinuxSubscriptionsDiscovery#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #linuxSubscriptionsDiscoveryAsString}.
     * </p>
     * 
     * @return Lists if discovery has been enabled for Linux subscriptions.
     * @see LinuxSubscriptionsDiscovery
     */
    public final LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery() {
        return LinuxSubscriptionsDiscovery.fromValue(linuxSubscriptionsDiscovery);
    }

    /**
     * <p>
     * Lists if discovery has been enabled for Linux subscriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #linuxSubscriptionsDiscovery} will return {@link LinuxSubscriptionsDiscovery#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #linuxSubscriptionsDiscoveryAsString}.
     * </p>
     * 
     * @return Lists if discovery has been enabled for Linux subscriptions.
     * @see LinuxSubscriptionsDiscovery
     */
    public final String linuxSubscriptionsDiscoveryAsString() {
        return linuxSubscriptionsDiscovery;
    }

    /**
     * <p>
     * The settings defined for Linux subscriptions discovery. The settings include if Organizations integration has
     * been enabled, and which Regions data will be aggregated from.
     * </p>
     * 
     * @return The settings defined for Linux subscriptions discovery. The settings include if Organizations integration
     *         has been enabled, and which Regions data will be aggregated from.
     */
    public final LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings() {
        return linuxSubscriptionsDiscoverySettings;
    }

    /**
     * <p>
     * Indicates the status of Linux subscriptions settings being applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of Linux subscriptions settings being applied.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of Linux subscriptions settings being applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of Linux subscriptions settings being applied.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusMessage property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusMessage() {
        return statusMessage != null && !(statusMessage instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A message which details the Linux subscriptions service settings current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusMessage} method.
     * </p>
     * 
     * @return A message which details the Linux subscriptions service settings current status.
     */
    public final Map<String, String> statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHomeRegions() ? homeRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(linuxSubscriptionsDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(linuxSubscriptionsDiscoverySettings());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusMessage() ? statusMessage() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSettingsResponse)) {
            return false;
        }
        UpdateServiceSettingsResponse other = (UpdateServiceSettingsResponse) obj;
        return hasHomeRegions() == other.hasHomeRegions() && Objects.equals(homeRegions(), other.homeRegions())
                && Objects.equals(linuxSubscriptionsDiscoveryAsString(), other.linuxSubscriptionsDiscoveryAsString())
                && Objects.equals(linuxSubscriptionsDiscoverySettings(), other.linuxSubscriptionsDiscoverySettings())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasStatusMessage() == other.hasStatusMessage()
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceSettingsResponse").add("HomeRegions", hasHomeRegions() ? homeRegions() : null)
                .add("LinuxSubscriptionsDiscovery", linuxSubscriptionsDiscoveryAsString())
                .add("LinuxSubscriptionsDiscoverySettings", linuxSubscriptionsDiscoverySettings())
                .add("Status", statusAsString()).add("StatusMessage", hasStatusMessage() ? statusMessage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HomeRegions":
            return Optional.ofNullable(clazz.cast(homeRegions()));
        case "LinuxSubscriptionsDiscovery":
            return Optional.ofNullable(clazz.cast(linuxSubscriptionsDiscoveryAsString()));
        case "LinuxSubscriptionsDiscoverySettings":
            return Optional.ofNullable(clazz.cast(linuxSubscriptionsDiscoverySettings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HomeRegions", HOME_REGIONS_FIELD);
        map.put("LinuxSubscriptionsDiscovery", LINUX_SUBSCRIPTIONS_DISCOVERY_FIELD);
        map.put("LinuxSubscriptionsDiscoverySettings", LINUX_SUBSCRIPTIONS_DISCOVERY_SETTINGS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSettingsResponse, T> g) {
        return obj -> g.apply((UpdateServiceSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LicenseManagerLinuxSubscriptionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceSettingsResponse> {
        /**
         * <p>
         * The Region in which License Manager displays the aggregated data for Linux subscriptions.
         * </p>
         * 
         * @param homeRegions
         *        The Region in which License Manager displays the aggregated data for Linux subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegions(Collection<String> homeRegions);

        /**
         * <p>
         * The Region in which License Manager displays the aggregated data for Linux subscriptions.
         * </p>
         * 
         * @param homeRegions
         *        The Region in which License Manager displays the aggregated data for Linux subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegions(String... homeRegions);

        /**
         * <p>
         * Lists if discovery has been enabled for Linux subscriptions.
         * </p>
         * 
         * @param linuxSubscriptionsDiscovery
         *        Lists if discovery has been enabled for Linux subscriptions.
         * @see LinuxSubscriptionsDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinuxSubscriptionsDiscovery
         */
        Builder linuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery);

        /**
         * <p>
         * Lists if discovery has been enabled for Linux subscriptions.
         * </p>
         * 
         * @param linuxSubscriptionsDiscovery
         *        Lists if discovery has been enabled for Linux subscriptions.
         * @see LinuxSubscriptionsDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinuxSubscriptionsDiscovery
         */
        Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery);

        /**
         * <p>
         * The settings defined for Linux subscriptions discovery. The settings include if Organizations integration has
         * been enabled, and which Regions data will be aggregated from.
         * </p>
         * 
         * @param linuxSubscriptionsDiscoverySettings
         *        The settings defined for Linux subscriptions discovery. The settings include if Organizations
         *        integration has been enabled, and which Regions data will be aggregated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings);

        /**
         * <p>
         * The settings defined for Linux subscriptions discovery. The settings include if Organizations integration has
         * been enabled, and which Regions data will be aggregated from.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LinuxSubscriptionsDiscoverySettings.Builder} avoiding the need to create one manually via
         * {@link LinuxSubscriptionsDiscoverySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinuxSubscriptionsDiscoverySettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings)}.
         * 
         * @param linuxSubscriptionsDiscoverySettings
         *        a consumer that will call methods on {@link LinuxSubscriptionsDiscoverySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings)
         */
        default Builder linuxSubscriptionsDiscoverySettings(
                Consumer<LinuxSubscriptionsDiscoverySettings.Builder> linuxSubscriptionsDiscoverySettings) {
            return linuxSubscriptionsDiscoverySettings(LinuxSubscriptionsDiscoverySettings.builder()
                    .applyMutation(linuxSubscriptionsDiscoverySettings).build());
        }

        /**
         * <p>
         * Indicates the status of Linux subscriptions settings being applied.
         * </p>
         * 
         * @param status
         *        Indicates the status of Linux subscriptions settings being applied.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of Linux subscriptions settings being applied.
         * </p>
         * 
         * @param status
         *        Indicates the status of Linux subscriptions settings being applied.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * A message which details the Linux subscriptions service settings current status.
         * </p>
         * 
         * @param statusMessage
         *        A message which details the Linux subscriptions service settings current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(Map<String, String> statusMessage);
    }

    static final class BuilderImpl extends LicenseManagerLinuxSubscriptionsResponse.BuilderImpl implements Builder {
        private List<String> homeRegions = DefaultSdkAutoConstructList.getInstance();

        private String linuxSubscriptionsDiscovery;

        private LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings;

        private String status;

        private Map<String, String> statusMessage = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSettingsResponse model) {
            super(model);
            homeRegions(model.homeRegions);
            linuxSubscriptionsDiscovery(model.linuxSubscriptionsDiscovery);
            linuxSubscriptionsDiscoverySettings(model.linuxSubscriptionsDiscoverySettings);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Collection<String> getHomeRegions() {
            if (homeRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return homeRegions;
        }

        public final void setHomeRegions(Collection<String> homeRegions) {
            this.homeRegions = StringListCopier.copy(homeRegions);
        }

        @Override
        public final Builder homeRegions(Collection<String> homeRegions) {
            this.homeRegions = StringListCopier.copy(homeRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeRegions(String... homeRegions) {
            homeRegions(Arrays.asList(homeRegions));
            return this;
        }

        public final String getLinuxSubscriptionsDiscovery() {
            return linuxSubscriptionsDiscovery;
        }

        public final void setLinuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(String linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery = linuxSubscriptionsDiscovery;
            return this;
        }

        @Override
        public final Builder linuxSubscriptionsDiscovery(LinuxSubscriptionsDiscovery linuxSubscriptionsDiscovery) {
            this.linuxSubscriptionsDiscovery(linuxSubscriptionsDiscovery == null ? null : linuxSubscriptionsDiscovery.toString());
            return this;
        }

        public final LinuxSubscriptionsDiscoverySettings.Builder getLinuxSubscriptionsDiscoverySettings() {
            return linuxSubscriptionsDiscoverySettings != null ? linuxSubscriptionsDiscoverySettings.toBuilder() : null;
        }

        public final void setLinuxSubscriptionsDiscoverySettings(
                LinuxSubscriptionsDiscoverySettings.BuilderImpl linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings != null ? linuxSubscriptionsDiscoverySettings
                    .build() : null;
        }

        @Override
        public final Builder linuxSubscriptionsDiscoverySettings(
                LinuxSubscriptionsDiscoverySettings linuxSubscriptionsDiscoverySettings) {
            this.linuxSubscriptionsDiscoverySettings = linuxSubscriptionsDiscoverySettings;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getStatusMessage() {
            if (statusMessage instanceof SdkAutoConstructMap) {
                return null;
            }
            return statusMessage;
        }

        public final void setStatusMessage(Map<String, String> statusMessage) {
            this.statusMessage = StringMapCopier.copy(statusMessage);
        }

        @Override
        public final Builder statusMessage(Map<String, String> statusMessage) {
            this.statusMessage = StringMapCopier.copy(statusMessage);
            return this;
        }

        @Override
        public UpdateServiceSettingsResponse build() {
            return new UpdateServiceSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
