/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.OrganizationConfiguration;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceSettingsRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, UpdateServiceSettingsRequest> {
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketArn").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::s3BucketArn)).setter(UpdateServiceSettingsRequest.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::snsTopicArn)).setter(UpdateServiceSettingsRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<OrganizationConfiguration> ORGANIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationConfiguration").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::organizationConfiguration)).setter(UpdateServiceSettingsRequest.setter(Builder::organizationConfiguration)).constructor(OrganizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfiguration").build()}).build();
    private static final SdkField<Boolean> ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCrossAccountsDiscovery").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::enableCrossAccountsDiscovery)).setter(UpdateServiceSettingsRequest.setter(Builder::enableCrossAccountsDiscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCrossAccountsDiscovery").build()}).build();
    private static final SdkField<List<String>> ENABLED_DISCOVERY_SOURCE_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledDiscoverySourceRegions").getter(UpdateServiceSettingsRequest.getter(UpdateServiceSettingsRequest::enabledDiscoverySourceRegions)).setter(UpdateServiceSettingsRequest.setter(Builder::enabledDiscoverySourceRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDiscoverySourceRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_ARN_FIELD, SNS_TOPIC_ARN_FIELD, ORGANIZATION_CONFIGURATION_FIELD, ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD, ENABLED_DISCOVERY_SOURCE_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceSettingsRequest.memberNameToFieldInitializer();
    private final String s3BucketArn;
    private final String snsTopicArn;
    private final OrganizationConfiguration organizationConfiguration;
    private final Boolean enableCrossAccountsDiscovery;
    private final List<String> enabledDiscoverySourceRegions;

    private UpdateServiceSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.s3BucketArn = builder.s3BucketArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.organizationConfiguration = builder.organizationConfiguration;
        this.enableCrossAccountsDiscovery = builder.enableCrossAccountsDiscovery;
        this.enabledDiscoverySourceRegions = builder.enabledDiscoverySourceRegions;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final OrganizationConfiguration organizationConfiguration() {
        return this.organizationConfiguration;
    }

    public final Boolean enableCrossAccountsDiscovery() {
        return this.enableCrossAccountsDiscovery;
    }

    public final boolean hasEnabledDiscoverySourceRegions() {
        return this.enabledDiscoverySourceRegions != null && !(this.enabledDiscoverySourceRegions instanceof SdkAutoConstructList);
    }

    public final List<String> enabledDiscoverySourceRegions() {
        return this.enabledDiscoverySourceRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCrossAccountsDiscovery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledDiscoverySourceRegions() ? this.enabledDiscoverySourceRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSettingsRequest)) {
            return false;
        }
        UpdateServiceSettingsRequest other = (UpdateServiceSettingsRequest)((Object)obj);
        return Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.organizationConfiguration(), other.organizationConfiguration()) && Objects.equals(this.enableCrossAccountsDiscovery(), other.enableCrossAccountsDiscovery()) && this.hasEnabledDiscoverySourceRegions() == other.hasEnabledDiscoverySourceRegions() && Objects.equals(this.enabledDiscoverySourceRegions(), other.enabledDiscoverySourceRegions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceSettingsRequest").add("S3BucketArn", (Object)this.s3BucketArn()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("OrganizationConfiguration", (Object)this.organizationConfiguration()).add("EnableCrossAccountsDiscovery", (Object)this.enableCrossAccountsDiscovery()).add("EnabledDiscoverySourceRegions", this.hasEnabledDiscoverySourceRegions() ? this.enabledDiscoverySourceRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "OrganizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.organizationConfiguration()));
            }
            case "EnableCrossAccountsDiscovery": {
                return Optional.ofNullable(clazz.cast(this.enableCrossAccountsDiscovery()));
            }
            case "EnabledDiscoverySourceRegions": {
                return Optional.ofNullable(clazz.cast(this.enabledDiscoverySourceRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3BucketArn", S3_BUCKET_ARN_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("OrganizationConfiguration", ORGANIZATION_CONFIGURATION_FIELD);
        map.put("EnableCrossAccountsDiscovery", ENABLE_CROSS_ACCOUNTS_DISCOVERY_FIELD);
        map.put("EnabledDiscoverySourceRegions", ENABLED_DISCOVERY_SOURCE_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSettingsRequest, T> g) {
        return obj -> g.apply((UpdateServiceSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String s3BucketArn;
        private String snsTopicArn;
        private OrganizationConfiguration organizationConfiguration;
        private Boolean enableCrossAccountsDiscovery;
        private List<String> enabledDiscoverySourceRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSettingsRequest model) {
            super(model);
            this.s3BucketArn(model.s3BucketArn);
            this.snsTopicArn(model.snsTopicArn);
            this.organizationConfiguration(model.organizationConfiguration);
            this.enableCrossAccountsDiscovery(model.enableCrossAccountsDiscovery);
            this.enabledDiscoverySourceRegions(model.enabledDiscoverySourceRegions);
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final OrganizationConfiguration.Builder getOrganizationConfiguration() {
            return this.organizationConfiguration != null ? this.organizationConfiguration.toBuilder() : null;
        }

        public final void setOrganizationConfiguration(OrganizationConfiguration.BuilderImpl organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration != null ? organizationConfiguration.build() : null;
        }

        @Override
        public final Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration;
            return this;
        }

        public final Boolean getEnableCrossAccountsDiscovery() {
            return this.enableCrossAccountsDiscovery;
        }

        public final void setEnableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
        }

        @Override
        public final Builder enableCrossAccountsDiscovery(Boolean enableCrossAccountsDiscovery) {
            this.enableCrossAccountsDiscovery = enableCrossAccountsDiscovery;
            return this;
        }

        public final Collection<String> getEnabledDiscoverySourceRegions() {
            if (this.enabledDiscoverySourceRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledDiscoverySourceRegions;
        }

        public final void setEnabledDiscoverySourceRegions(Collection<String> enabledDiscoverySourceRegions) {
            this.enabledDiscoverySourceRegions = StringListCopier.copy(enabledDiscoverySourceRegions);
        }

        @Override
        public final Builder enabledDiscoverySourceRegions(Collection<String> enabledDiscoverySourceRegions) {
            this.enabledDiscoverySourceRegions = StringListCopier.copy(enabledDiscoverySourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledDiscoverySourceRegions(String ... enabledDiscoverySourceRegions) {
            this.enabledDiscoverySourceRegions(Arrays.asList(enabledDiscoverySourceRegions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceSettingsRequest build() {
            return new UpdateServiceSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceSettingsRequest> {
        public Builder s3BucketArn(String var1);

        public Builder snsTopicArn(String var1);

        public Builder organizationConfiguration(OrganizationConfiguration var1);

        default public Builder organizationConfiguration(Consumer<OrganizationConfiguration.Builder> organizationConfiguration) {
            return this.organizationConfiguration((OrganizationConfiguration)((OrganizationConfiguration.Builder)OrganizationConfiguration.builder().applyMutation(organizationConfiguration)).build());
        }

        public Builder enableCrossAccountsDiscovery(Boolean var1);

        public Builder enabledDiscoverySourceRegions(Collection<String> var1);

        public Builder enabledDiscoverySourceRegions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

