/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.CrossAccountDiscoveryServiceStatus;
import software.amazon.awssdk.services.licensemanager.model.CrossRegionDiscoveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceStatus> {
    private static final SdkField<CrossAccountDiscoveryServiceStatus> CROSS_ACCOUNT_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CrossAccountDiscovery").getter(ServiceStatus.getter(ServiceStatus::crossAccountDiscovery)).setter(ServiceStatus.setter(Builder::crossAccountDiscovery)).constructor(CrossAccountDiscoveryServiceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountDiscovery").build()}).build();
    private static final SdkField<CrossRegionDiscoveryStatus> CROSS_REGION_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CrossRegionDiscovery").getter(ServiceStatus.getter(ServiceStatus::crossRegionDiscovery)).setter(ServiceStatus.setter(Builder::crossRegionDiscovery)).constructor(CrossRegionDiscoveryStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionDiscovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_DISCOVERY_FIELD, CROSS_REGION_DISCOVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CrossAccountDiscoveryServiceStatus crossAccountDiscovery;
    private final CrossRegionDiscoveryStatus crossRegionDiscovery;

    private ServiceStatus(BuilderImpl builder) {
        this.crossAccountDiscovery = builder.crossAccountDiscovery;
        this.crossRegionDiscovery = builder.crossRegionDiscovery;
    }

    public final CrossAccountDiscoveryServiceStatus crossAccountDiscovery() {
        return this.crossAccountDiscovery;
    }

    public final CrossRegionDiscoveryStatus crossRegionDiscovery() {
        return this.crossRegionDiscovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountDiscovery());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossRegionDiscovery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceStatus)) {
            return false;
        }
        ServiceStatus other = (ServiceStatus)obj;
        return Objects.equals(this.crossAccountDiscovery(), other.crossAccountDiscovery()) && Objects.equals(this.crossRegionDiscovery(), other.crossRegionDiscovery());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceStatus").add("CrossAccountDiscovery", (Object)this.crossAccountDiscovery()).add("CrossRegionDiscovery", (Object)this.crossRegionDiscovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrossAccountDiscovery": {
                return Optional.ofNullable(clazz.cast(this.crossAccountDiscovery()));
            }
            case "CrossRegionDiscovery": {
                return Optional.ofNullable(clazz.cast(this.crossRegionDiscovery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CrossAccountDiscovery", CROSS_ACCOUNT_DISCOVERY_FIELD);
        map.put("CrossRegionDiscovery", CROSS_REGION_DISCOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceStatus, T> g) {
        return obj -> g.apply((ServiceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CrossAccountDiscoveryServiceStatus crossAccountDiscovery;
        private CrossRegionDiscoveryStatus crossRegionDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceStatus model) {
            this.crossAccountDiscovery(model.crossAccountDiscovery);
            this.crossRegionDiscovery(model.crossRegionDiscovery);
        }

        public final CrossAccountDiscoveryServiceStatus.Builder getCrossAccountDiscovery() {
            return this.crossAccountDiscovery != null ? this.crossAccountDiscovery.toBuilder() : null;
        }

        public final void setCrossAccountDiscovery(CrossAccountDiscoveryServiceStatus.BuilderImpl crossAccountDiscovery) {
            this.crossAccountDiscovery = crossAccountDiscovery != null ? crossAccountDiscovery.build() : null;
        }

        @Override
        public final Builder crossAccountDiscovery(CrossAccountDiscoveryServiceStatus crossAccountDiscovery) {
            this.crossAccountDiscovery = crossAccountDiscovery;
            return this;
        }

        public final CrossRegionDiscoveryStatus.Builder getCrossRegionDiscovery() {
            return this.crossRegionDiscovery != null ? this.crossRegionDiscovery.toBuilder() : null;
        }

        public final void setCrossRegionDiscovery(CrossRegionDiscoveryStatus.BuilderImpl crossRegionDiscovery) {
            this.crossRegionDiscovery = crossRegionDiscovery != null ? crossRegionDiscovery.build() : null;
        }

        @Override
        public final Builder crossRegionDiscovery(CrossRegionDiscoveryStatus crossRegionDiscovery) {
            this.crossRegionDiscovery = crossRegionDiscovery;
            return this;
        }

        public ServiceStatus build() {
            return new ServiceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceStatus> {
        public Builder crossAccountDiscovery(CrossAccountDiscoveryServiceStatus var1);

        default public Builder crossAccountDiscovery(Consumer<CrossAccountDiscoveryServiceStatus.Builder> crossAccountDiscovery) {
            return this.crossAccountDiscovery((CrossAccountDiscoveryServiceStatus)((CrossAccountDiscoveryServiceStatus.Builder)CrossAccountDiscoveryServiceStatus.builder().applyMutation(crossAccountDiscovery)).build());
        }

        public Builder crossRegionDiscovery(CrossRegionDiscoveryStatus var1);

        default public Builder crossRegionDiscovery(Consumer<CrossRegionDiscoveryStatus.Builder> crossRegionDiscovery) {
            return this.crossRegionDiscovery((CrossRegionDiscoveryStatus)((CrossRegionDiscoveryStatus.Builder)CrossRegionDiscoveryStatus.builder().applyMutation(crossRegionDiscovery)).build());
        }
    }
}

