/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchingRuleStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchingRuleStatement> {
    private static final SdkField<String> KEY_TO_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyToMatch").getter(MatchingRuleStatement.getter(MatchingRuleStatement::keyToMatch)).setter(MatchingRuleStatement.setter(Builder::keyToMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyToMatch").build()}).build();
    private static final SdkField<String> CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Constraint").getter(MatchingRuleStatement.getter(MatchingRuleStatement::constraint)).setter(MatchingRuleStatement.setter(Builder::constraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraint").build()}).build();
    private static final SdkField<List<String>> VALUE_TO_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValueToMatch").getter(MatchingRuleStatement.getter(MatchingRuleStatement::valueToMatch)).setter(MatchingRuleStatement.setter(Builder::valueToMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueToMatch").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_TO_MATCH_FIELD, CONSTRAINT_FIELD, VALUE_TO_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MatchingRuleStatement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyToMatch;
    private final String constraint;
    private final List<String> valueToMatch;

    private MatchingRuleStatement(BuilderImpl builder) {
        this.keyToMatch = builder.keyToMatch;
        this.constraint = builder.constraint;
        this.valueToMatch = builder.valueToMatch;
    }

    public final String keyToMatch() {
        return this.keyToMatch;
    }

    public final String constraint() {
        return this.constraint;
    }

    public final boolean hasValueToMatch() {
        return this.valueToMatch != null && !(this.valueToMatch instanceof SdkAutoConstructList);
    }

    public final List<String> valueToMatch() {
        return this.valueToMatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueToMatch() ? this.valueToMatch() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingRuleStatement)) {
            return false;
        }
        MatchingRuleStatement other = (MatchingRuleStatement)obj;
        return Objects.equals(this.keyToMatch(), other.keyToMatch()) && Objects.equals(this.constraint(), other.constraint()) && this.hasValueToMatch() == other.hasValueToMatch() && Objects.equals(this.valueToMatch(), other.valueToMatch());
    }

    public final String toString() {
        return ToString.builder((String)"MatchingRuleStatement").add("KeyToMatch", (Object)this.keyToMatch()).add("Constraint", (Object)this.constraint()).add("ValueToMatch", this.hasValueToMatch() ? this.valueToMatch() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyToMatch": {
                return Optional.ofNullable(clazz.cast(this.keyToMatch()));
            }
            case "Constraint": {
                return Optional.ofNullable(clazz.cast(this.constraint()));
            }
            case "ValueToMatch": {
                return Optional.ofNullable(clazz.cast(this.valueToMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyToMatch", KEY_TO_MATCH_FIELD);
        map.put("Constraint", CONSTRAINT_FIELD);
        map.put("ValueToMatch", VALUE_TO_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchingRuleStatement, T> g) {
        return obj -> g.apply((MatchingRuleStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyToMatch;
        private String constraint;
        private List<String> valueToMatch = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingRuleStatement model) {
            this.keyToMatch(model.keyToMatch);
            this.constraint(model.constraint);
            this.valueToMatch(model.valueToMatch);
        }

        public final String getKeyToMatch() {
            return this.keyToMatch;
        }

        public final void setKeyToMatch(String keyToMatch) {
            this.keyToMatch = keyToMatch;
        }

        @Override
        public final Builder keyToMatch(String keyToMatch) {
            this.keyToMatch = keyToMatch;
            return this;
        }

        public final String getConstraint() {
            return this.constraint;
        }

        public final void setConstraint(String constraint) {
            this.constraint = constraint;
        }

        @Override
        public final Builder constraint(String constraint) {
            this.constraint = constraint;
            return this;
        }

        public final Collection<String> getValueToMatch() {
            if (this.valueToMatch instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valueToMatch;
        }

        public final void setValueToMatch(Collection<String> valueToMatch) {
            this.valueToMatch = StringListCopier.copy(valueToMatch);
        }

        @Override
        public final Builder valueToMatch(Collection<String> valueToMatch) {
            this.valueToMatch = StringListCopier.copy(valueToMatch);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueToMatch(String ... valueToMatch) {
            this.valueToMatch(Arrays.asList(valueToMatch));
            return this;
        }

        public MatchingRuleStatement build() {
            return new MatchingRuleStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchingRuleStatement> {
        public Builder keyToMatch(String var1);

        public Builder constraint(String var1);

        public Builder valueToMatch(Collection<String> var1);

        public Builder valueToMatch(String ... var1);
    }
}

