/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.licensemanager.model.RegionStatus;
import software.amazon.awssdk.services.licensemanager.model.RegionStatusMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrossRegionDiscoveryStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrossRegionDiscoveryStatus> {
    private static final SdkField<Map<String, RegionStatus>> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Message").getter(CrossRegionDiscoveryStatus.getter(CrossRegionDiscoveryStatus::message)).setter(CrossRegionDiscoveryStatus.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CrossRegionDiscoveryStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, RegionStatus> message;

    private CrossRegionDiscoveryStatus(BuilderImpl builder) {
        this.message = builder.message;
    }

    public final boolean hasMessage() {
        return this.message != null && !(this.message instanceof SdkAutoConstructMap);
    }

    public final Map<String, RegionStatus> message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessage() ? this.message() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionDiscoveryStatus)) {
            return false;
        }
        CrossRegionDiscoveryStatus other = (CrossRegionDiscoveryStatus)obj;
        return this.hasMessage() == other.hasMessage() && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"CrossRegionDiscoveryStatus").add("Message", this.hasMessage() ? this.message() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, RegionStatus>>> map = new HashMap<String, SdkField<Map<String, RegionStatus>>>();
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionDiscoveryStatus, T> g) {
        return obj -> g.apply((CrossRegionDiscoveryStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, RegionStatus> message = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionDiscoveryStatus model) {
            this.message(model.message);
        }

        public final Map<String, RegionStatus.Builder> getMessage() {
            Map<String, RegionStatus.Builder> result = RegionStatusMapCopier.copyToBuilder(this.message);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessage(Map<String, RegionStatus.BuilderImpl> message) {
            this.message = RegionStatusMapCopier.copyFromBuilder(message);
        }

        @Override
        public final Builder message(Map<String, RegionStatus> message) {
            this.message = RegionStatusMapCopier.copy(message);
            return this;
        }

        public CrossRegionDiscoveryStatus build() {
            return new CrossRegionDiscoveryStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrossRegionDiscoveryStatus> {
        public Builder message(Map<String, RegionStatus> var1);
    }
}

