/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupConfiguration;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupConfigurationListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupProperty;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupPropertyListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetRulesetArnListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.Tag;
import software.amazon.awssdk.services.licensemanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseAssetGroupRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateLicenseAssetGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateLicenseAssetGroupRequest.getter(CreateLicenseAssetGroupRequest::name)).setter(CreateLicenseAssetGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateLicenseAssetGroupRequest.getter(CreateLicenseAssetGroupRequest::description)).setter(CreateLicenseAssetGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<LicenseAssetGroupConfiguration>> LICENSE_ASSET_GROUP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseAssetGroupConfigurations").getter(CreateLicenseAssetGroupRequest.getter(CreateLicenseAssetGroupRequest::licenseAssetGroupConfigurations)).setter(CreateLicenseAssetGroupRequest.setter(Builder::licenseAssetGroupConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetGroupConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseAssetGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_LICENSE_ASSET_RULESET_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedLicenseAssetRulesetARNs").getter(CreateLicenseAssetGroupRequest.getter(CreateLicenseAssetGroupRequest::associatedLicenseAssetRulesetARNs)).setter(CreateLicenseAssetGroupRequest.setter(Builder::associatedLicenseAssetRulesetARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedLicenseAssetRulesetARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LicenseAssetGroupProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Properties").getter(CreateLicenseAssetGroupRequest.getter(CreateLicenseAssetGroupRequest::properties)).setter(CreateLicenseAssetGroupRequest.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseAssetGroupProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLicenseAssetGroupRequest.getter(CreateLicenseAssetGroupRequest::tags)).setter(CreateLicenseAssetGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateLicenseAssetGroupRequest.getter(CreateLicenseAssetGroupRequest::clientToken)).setter(CreateLicenseAssetGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, LICENSE_ASSET_GROUP_CONFIGURATIONS_FIELD, ASSOCIATED_LICENSE_ASSET_RULESET_AR_NS_FIELD, PROPERTIES_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLicenseAssetGroupRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations;
    private final List<String> associatedLicenseAssetRulesetARNs;
    private final List<LicenseAssetGroupProperty> properties;
    private final List<Tag> tags;
    private final String clientToken;

    private CreateLicenseAssetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.licenseAssetGroupConfigurations = builder.licenseAssetGroupConfigurations;
        this.associatedLicenseAssetRulesetARNs = builder.associatedLicenseAssetRulesetARNs;
        this.properties = builder.properties;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasLicenseAssetGroupConfigurations() {
        return this.licenseAssetGroupConfigurations != null && !(this.licenseAssetGroupConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations() {
        return this.licenseAssetGroupConfigurations;
    }

    public final boolean hasAssociatedLicenseAssetRulesetARNs() {
        return this.associatedLicenseAssetRulesetARNs != null && !(this.associatedLicenseAssetRulesetARNs instanceof SdkAutoConstructList);
    }

    public final List<String> associatedLicenseAssetRulesetARNs() {
        return this.associatedLicenseAssetRulesetARNs;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<LicenseAssetGroupProperty> properties() {
        return this.properties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseAssetGroupConfigurations() ? this.licenseAssetGroupConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedLicenseAssetRulesetARNs() ? this.associatedLicenseAssetRulesetARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseAssetGroupRequest)) {
            return false;
        }
        CreateLicenseAssetGroupRequest other = (CreateLicenseAssetGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasLicenseAssetGroupConfigurations() == other.hasLicenseAssetGroupConfigurations() && Objects.equals(this.licenseAssetGroupConfigurations(), other.licenseAssetGroupConfigurations()) && this.hasAssociatedLicenseAssetRulesetARNs() == other.hasAssociatedLicenseAssetRulesetARNs() && Objects.equals(this.associatedLicenseAssetRulesetARNs(), other.associatedLicenseAssetRulesetARNs()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseAssetGroupRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LicenseAssetGroupConfigurations", this.hasLicenseAssetGroupConfigurations() ? this.licenseAssetGroupConfigurations() : null).add("AssociatedLicenseAssetRulesetARNs", this.hasAssociatedLicenseAssetRulesetARNs() ? this.associatedLicenseAssetRulesetARNs() : null).add("Properties", this.hasProperties() ? this.properties() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LicenseAssetGroupConfigurations": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroupConfigurations()));
            }
            case "AssociatedLicenseAssetRulesetARNs": {
                return Optional.ofNullable(clazz.cast(this.associatedLicenseAssetRulesetARNs()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LicenseAssetGroupConfigurations", LICENSE_ASSET_GROUP_CONFIGURATIONS_FIELD);
        map.put("AssociatedLicenseAssetRulesetARNs", ASSOCIATED_LICENSE_ASSET_RULESET_AR_NS_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseAssetGroupRequest, T> g) {
        return obj -> g.apply((CreateLicenseAssetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<String> associatedLicenseAssetRulesetARNs = DefaultSdkAutoConstructList.getInstance();
        private List<LicenseAssetGroupProperty> properties = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseAssetGroupRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.licenseAssetGroupConfigurations(model.licenseAssetGroupConfigurations);
            this.associatedLicenseAssetRulesetARNs(model.associatedLicenseAssetRulesetARNs);
            this.properties(model.properties);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<LicenseAssetGroupConfiguration.Builder> getLicenseAssetGroupConfigurations() {
            List<LicenseAssetGroupConfiguration.Builder> result = LicenseAssetGroupConfigurationListCopier.copyToBuilder(this.licenseAssetGroupConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseAssetGroupConfigurations(Collection<LicenseAssetGroupConfiguration.BuilderImpl> licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations = LicenseAssetGroupConfigurationListCopier.copyFromBuilder(licenseAssetGroupConfigurations);
        }

        @Override
        public final Builder licenseAssetGroupConfigurations(Collection<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations = LicenseAssetGroupConfigurationListCopier.copy(licenseAssetGroupConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetGroupConfigurations(LicenseAssetGroupConfiguration ... licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations(Arrays.asList(licenseAssetGroupConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetGroupConfigurations(Consumer<LicenseAssetGroupConfiguration.Builder> ... licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations(Stream.of(licenseAssetGroupConfigurations).map(c -> (LicenseAssetGroupConfiguration)((LicenseAssetGroupConfiguration.Builder)LicenseAssetGroupConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedLicenseAssetRulesetARNs() {
            if (this.associatedLicenseAssetRulesetARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedLicenseAssetRulesetARNs;
        }

        public final void setAssociatedLicenseAssetRulesetARNs(Collection<String> associatedLicenseAssetRulesetARNs) {
            this.associatedLicenseAssetRulesetARNs = LicenseAssetRulesetArnListCopier.copy(associatedLicenseAssetRulesetARNs);
        }

        @Override
        public final Builder associatedLicenseAssetRulesetARNs(Collection<String> associatedLicenseAssetRulesetARNs) {
            this.associatedLicenseAssetRulesetARNs = LicenseAssetRulesetArnListCopier.copy(associatedLicenseAssetRulesetARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedLicenseAssetRulesetARNs(String ... associatedLicenseAssetRulesetARNs) {
            this.associatedLicenseAssetRulesetARNs(Arrays.asList(associatedLicenseAssetRulesetARNs));
            return this;
        }

        public final List<LicenseAssetGroupProperty.Builder> getProperties() {
            List<LicenseAssetGroupProperty.Builder> result = LicenseAssetGroupPropertyListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<LicenseAssetGroupProperty.BuilderImpl> properties) {
            this.properties = LicenseAssetGroupPropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<LicenseAssetGroupProperty> properties) {
            this.properties = LicenseAssetGroupPropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(LicenseAssetGroupProperty ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<LicenseAssetGroupProperty.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (LicenseAssetGroupProperty)((LicenseAssetGroupProperty.Builder)LicenseAssetGroupProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseAssetGroupRequest build() {
            return new CreateLicenseAssetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseAssetGroupRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder licenseAssetGroupConfigurations(Collection<LicenseAssetGroupConfiguration> var1);

        public Builder licenseAssetGroupConfigurations(LicenseAssetGroupConfiguration ... var1);

        public Builder licenseAssetGroupConfigurations(Consumer<LicenseAssetGroupConfiguration.Builder> ... var1);

        public Builder associatedLicenseAssetRulesetARNs(Collection<String> var1);

        public Builder associatedLicenseAssetRulesetARNs(String ... var1);

        public Builder properties(Collection<LicenseAssetGroupProperty> var1);

        public Builder properties(LicenseAssetGroupProperty ... var1);

        public Builder properties(Consumer<LicenseAssetGroupProperty.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

