/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.TokenType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTokenResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, CreateTokenResponse> {
    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenId").getter(CreateTokenResponse.getter(CreateTokenResponse::tokenId)).setter(CreateTokenResponse.setter(Builder::tokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenId").build()}).build();
    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenType").getter(CreateTokenResponse.getter(CreateTokenResponse::tokenTypeAsString)).setter(CreateTokenResponse.setter(Builder::tokenType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenType").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Token").getter(CreateTokenResponse.getter(CreateTokenResponse::token)).setter(CreateTokenResponse.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_ID_FIELD, TOKEN_TYPE_FIELD, TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTokenResponse.memberNameToFieldInitializer();
    private final String tokenId;
    private final String tokenType;
    private final String token;

    private CreateTokenResponse(BuilderImpl builder) {
        super(builder);
        this.tokenId = builder.tokenId;
        this.tokenType = builder.tokenType;
        this.token = builder.token;
    }

    public final String tokenId() {
        return this.tokenId;
    }

    public final TokenType tokenType() {
        return TokenType.fromValue(this.tokenType);
    }

    public final String tokenTypeAsString() {
        return this.tokenType;
    }

    public final String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenResponse)) {
            return false;
        }
        CreateTokenResponse other = (CreateTokenResponse)((Object)obj);
        return Objects.equals(this.tokenId(), other.tokenId()) && Objects.equals(this.tokenTypeAsString(), other.tokenTypeAsString()) && Objects.equals(this.token(), other.token());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTokenResponse").add("TokenId", (Object)this.tokenId()).add("TokenType", (Object)this.tokenTypeAsString()).add("Token", (Object)this.token()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TokenId": {
                return Optional.ofNullable(clazz.cast(this.tokenId()));
            }
            case "TokenType": {
                return Optional.ofNullable(clazz.cast(this.tokenTypeAsString()));
            }
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TokenId", TOKEN_ID_FIELD);
        map.put("TokenType", TOKEN_TYPE_FIELD);
        map.put("Token", TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenResponse, T> g) {
        return obj -> g.apply((CreateTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String tokenId;
        private String tokenType;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenResponse model) {
            super(model);
            this.tokenId(model.tokenId);
            this.tokenType(model.tokenType);
            this.token(model.token);
        }

        public final String getTokenId() {
            return this.tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getTokenType() {
            return this.tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @Override
        public final Builder tokenType(TokenType tokenType) {
            this.tokenType(tokenType == null ? null : tokenType.toString());
            return this;
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public CreateTokenResponse build() {
            return new CreateTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTokenResponse> {
        public Builder tokenId(String var1);

        public Builder tokenType(String var1);

        public Builder tokenType(TokenType var1);

        public Builder token(String var1);
    }
}

