/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.ReportContext;
import software.amazon.awssdk.services.licensemanager.model.ReportFrequency;
import software.amazon.awssdk.services.licensemanager.model.ReportType;
import software.amazon.awssdk.services.licensemanager.model.ReportTypeListCopier;
import software.amazon.awssdk.services.licensemanager.model.Tag;
import software.amazon.awssdk.services.licensemanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseManagerReportGeneratorRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateLicenseManagerReportGeneratorRequest> {
    private static final SdkField<String> REPORT_GENERATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportGeneratorName").getter(CreateLicenseManagerReportGeneratorRequest.getter(CreateLicenseManagerReportGeneratorRequest::reportGeneratorName)).setter(CreateLicenseManagerReportGeneratorRequest.setter(Builder::reportGeneratorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGeneratorName").build()}).build();
    private static final SdkField<List<String>> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Type").getter(CreateLicenseManagerReportGeneratorRequest.getter(CreateLicenseManagerReportGeneratorRequest::typeAsStrings)).setter(CreateLicenseManagerReportGeneratorRequest.setter(Builder::typeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReportContext> REPORT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportContext").getter(CreateLicenseManagerReportGeneratorRequest.getter(CreateLicenseManagerReportGeneratorRequest::reportContext)).setter(CreateLicenseManagerReportGeneratorRequest.setter(Builder::reportContext)).constructor(ReportContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportContext").build()}).build();
    private static final SdkField<ReportFrequency> REPORT_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportFrequency").getter(CreateLicenseManagerReportGeneratorRequest.getter(CreateLicenseManagerReportGeneratorRequest::reportFrequency)).setter(CreateLicenseManagerReportGeneratorRequest.setter(Builder::reportFrequency)).constructor(ReportFrequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportFrequency").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateLicenseManagerReportGeneratorRequest.getter(CreateLicenseManagerReportGeneratorRequest::clientToken)).setter(CreateLicenseManagerReportGeneratorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateLicenseManagerReportGeneratorRequest.getter(CreateLicenseManagerReportGeneratorRequest::description)).setter(CreateLicenseManagerReportGeneratorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLicenseManagerReportGeneratorRequest.getter(CreateLicenseManagerReportGeneratorRequest::tags)).setter(CreateLicenseManagerReportGeneratorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GENERATOR_NAME_FIELD, TYPE_FIELD, REPORT_CONTEXT_FIELD, REPORT_FREQUENCY_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLicenseManagerReportGeneratorRequest.memberNameToFieldInitializer();
    private final String reportGeneratorName;
    private final List<String> type;
    private final ReportContext reportContext;
    private final ReportFrequency reportFrequency;
    private final String clientToken;
    private final String description;
    private final List<Tag> tags;

    private CreateLicenseManagerReportGeneratorRequest(BuilderImpl builder) {
        super(builder);
        this.reportGeneratorName = builder.reportGeneratorName;
        this.type = builder.type;
        this.reportContext = builder.reportContext;
        this.reportFrequency = builder.reportFrequency;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String reportGeneratorName() {
        return this.reportGeneratorName;
    }

    public final List<ReportType> type() {
        return ReportTypeListCopier.copyStringToEnum(this.type);
    }

    public final boolean hasType() {
        return this.type != null && !(this.type instanceof SdkAutoConstructList);
    }

    public final List<String> typeAsStrings() {
        return this.type;
    }

    public final ReportContext reportContext() {
        return this.reportContext;
    }

    public final ReportFrequency reportFrequency() {
        return this.reportFrequency;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportGeneratorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasType() ? this.typeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseManagerReportGeneratorRequest)) {
            return false;
        }
        CreateLicenseManagerReportGeneratorRequest other = (CreateLicenseManagerReportGeneratorRequest)((Object)obj);
        return Objects.equals(this.reportGeneratorName(), other.reportGeneratorName()) && this.hasType() == other.hasType() && Objects.equals(this.typeAsStrings(), other.typeAsStrings()) && Objects.equals(this.reportContext(), other.reportContext()) && Objects.equals(this.reportFrequency(), other.reportFrequency()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseManagerReportGeneratorRequest").add("ReportGeneratorName", (Object)this.reportGeneratorName()).add("Type", this.hasType() ? this.typeAsStrings() : null).add("ReportContext", (Object)this.reportContext()).add("ReportFrequency", (Object)this.reportFrequency()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportGeneratorName": {
                return Optional.ofNullable(clazz.cast(this.reportGeneratorName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsStrings()));
            }
            case "ReportContext": {
                return Optional.ofNullable(clazz.cast(this.reportContext()));
            }
            case "ReportFrequency": {
                return Optional.ofNullable(clazz.cast(this.reportFrequency()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportGeneratorName", REPORT_GENERATOR_NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ReportContext", REPORT_CONTEXT_FIELD);
        map.put("ReportFrequency", REPORT_FREQUENCY_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseManagerReportGeneratorRequest, T> g) {
        return obj -> g.apply((CreateLicenseManagerReportGeneratorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String reportGeneratorName;
        private List<String> type = DefaultSdkAutoConstructList.getInstance();
        private ReportContext reportContext;
        private ReportFrequency reportFrequency;
        private String clientToken;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseManagerReportGeneratorRequest model) {
            super(model);
            this.reportGeneratorName(model.reportGeneratorName);
            this.typeWithStrings(model.type);
            this.reportContext(model.reportContext);
            this.reportFrequency(model.reportFrequency);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getReportGeneratorName() {
            return this.reportGeneratorName;
        }

        public final void setReportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
        }

        @Override
        public final Builder reportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
            return this;
        }

        public final Collection<String> getType() {
            if (this.type instanceof SdkAutoConstructList) {
                return null;
            }
            return this.type;
        }

        public final void setType(Collection<String> type) {
            this.type = ReportTypeListCopier.copy(type);
        }

        @Override
        public final Builder typeWithStrings(Collection<String> type) {
            this.type = ReportTypeListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeWithStrings(String ... type) {
            this.typeWithStrings(Arrays.asList(type));
            return this;
        }

        @Override
        public final Builder type(Collection<ReportType> type) {
            this.type = ReportTypeListCopier.copyEnumToString(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(ReportType ... type) {
            this.type(Arrays.asList(type));
            return this;
        }

        public final ReportContext.Builder getReportContext() {
            return this.reportContext != null ? this.reportContext.toBuilder() : null;
        }

        public final void setReportContext(ReportContext.BuilderImpl reportContext) {
            this.reportContext = reportContext != null ? reportContext.build() : null;
        }

        @Override
        public final Builder reportContext(ReportContext reportContext) {
            this.reportContext = reportContext;
            return this;
        }

        public final ReportFrequency.Builder getReportFrequency() {
            return this.reportFrequency != null ? this.reportFrequency.toBuilder() : null;
        }

        public final void setReportFrequency(ReportFrequency.BuilderImpl reportFrequency) {
            this.reportFrequency = reportFrequency != null ? reportFrequency.build() : null;
        }

        @Override
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseManagerReportGeneratorRequest build() {
            return new CreateLicenseManagerReportGeneratorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseManagerReportGeneratorRequest> {
        public Builder reportGeneratorName(String var1);

        public Builder typeWithStrings(Collection<String> var1);

        public Builder typeWithStrings(String ... var1);

        public Builder type(Collection<ReportType> var1);

        public Builder type(ReportType ... var1);

        public Builder reportContext(ReportContext var1);

        default public Builder reportContext(Consumer<ReportContext.Builder> reportContext) {
            return this.reportContext((ReportContext)((ReportContext.Builder)ReportContext.builder().applyMutation(reportContext)).build());
        }

        public Builder reportFrequency(ReportFrequency var1);

        default public Builder reportFrequency(Consumer<ReportFrequency.Builder> reportFrequency) {
            return this.reportFrequency((ReportFrequency)((ReportFrequency.Builder)ReportFrequency.builder().applyMutation(reportFrequency)).build());
        }

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

