/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.ReportFrequencyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportFrequency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportFrequency> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("value").getter(ReportFrequency.getter(ReportFrequency::value)).setter(ReportFrequency.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(ReportFrequency.getter(ReportFrequency::periodAsString)).setter(ReportFrequency.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("value", VALUE_FIELD);
            this.put("period", PERIOD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer value;
    private final String period;

    private ReportFrequency(BuilderImpl builder) {
        this.value = builder.value;
        this.period = builder.period;
    }

    public final Integer value() {
        return this.value;
    }

    public final ReportFrequencyType period() {
        return ReportFrequencyType.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportFrequency)) {
            return false;
        }
        ReportFrequency other = (ReportFrequency)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.periodAsString(), other.periodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReportFrequency").add("Value", (Object)this.value()).add("Period", (Object)this.periodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReportFrequency, T> g) {
        return obj -> g.apply((ReportFrequency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer value;
        private String period;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportFrequency model) {
            this.value(model.value);
            this.period(model.period);
        }

        public final Integer getValue() {
            return this.value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(ReportFrequencyType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public ReportFrequency build() {
            return new ReportFrequency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportFrequency> {
        public Builder value(Integer var1);

        public Builder period(String var1);

        public Builder period(ReportFrequencyType var1);
    }
}

