/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.licensemanager.DefaultLicenseManagerBaseClientBuilder;
import software.amazon.awssdk.services.licensemanager.DefaultLicenseManagerClient;
import software.amazon.awssdk.services.licensemanager.LicenseManagerClient;
import software.amazon.awssdk.services.licensemanager.LicenseManagerClientBuilder;
import software.amazon.awssdk.services.licensemanager.LicenseManagerServiceClientConfiguration;
import software.amazon.awssdk.services.licensemanager.endpoints.LicenseManagerEndpointProvider;

@SdkInternalApi
final class DefaultLicenseManagerClientBuilder
extends DefaultLicenseManagerBaseClientBuilder<LicenseManagerClientBuilder, LicenseManagerClient>
implements LicenseManagerClientBuilder {
    DefaultLicenseManagerClientBuilder() {
    }

    @Override
    public DefaultLicenseManagerClientBuilder endpointProvider(LicenseManagerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LicenseManagerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLicenseManagerClientBuilder.validateClientOptions(clientConfiguration);
        LicenseManagerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLicenseManagerClient client = new DefaultLicenseManagerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LicenseManagerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LicenseManagerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

