/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.licensemanager.LicenseManagerClient;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.AcceptGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.AccessDeniedException;
import software.amazon.awssdk.services.licensemanager.model.AuthorizationException;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckInLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutBorrowLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.ConflictException;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.DeleteTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.EntitlementNotAllowedException;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest;
import software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse;
import software.amazon.awssdk.services.licensemanager.model.FailedDependencyException;
import software.amazon.awssdk.services.licensemanager.model.FilterLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.licensemanager.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.licensemanager.model.GetGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.GetGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseConversionTaskResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseResponse;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageRequest;
import software.amazon.awssdk.services.licensemanager.model.GetLicenseUsageResponse;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.GetServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.InvalidParameterValueException;
import software.amazon.awssdk.services.licensemanager.model.InvalidResourceStateException;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerException;
import software.amazon.awssdk.services.licensemanager.model.LicenseUsageException;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListDistributedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseConversionTasksResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicenseVersionsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsForOrganizationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsForOrganizationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesForOrganizationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesForOrganizationResponse;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesRequest;
import software.amazon.awssdk.services.licensemanager.model.ListReceivedLicensesResponse;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryRequest;
import software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.ListTokensRequest;
import software.amazon.awssdk.services.licensemanager.model.ListTokensResponse;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.NoEntitlementsAllowedException;
import software.amazon.awssdk.services.licensemanager.model.RateLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.RedirectException;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantRequest;
import software.amazon.awssdk.services.licensemanager.model.RejectGrantResponse;
import software.amazon.awssdk.services.licensemanager.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.licensemanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.licensemanager.model.ServerInternalException;
import software.amazon.awssdk.services.licensemanager.model.TagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.TagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UnsupportedDigitalSignatureMethodException;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest;
import software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsResponse;
import software.amazon.awssdk.services.licensemanager.model.ValidationException;
import software.amazon.awssdk.services.licensemanager.transform.AcceptGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CheckInLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CheckoutBorrowLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CheckoutLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateGrantVersionRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseConversionTaskForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateLicenseVersionRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.CreateTokenRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.DeleteTokenRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ExtendLicenseConsumptionRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseConversionTaskRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetLicenseUsageRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.GetServiceSettingsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListAssociationsForLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListDistributedGrantsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListFailuresForLicenseConfigurationOperationsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseConversionTasksRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseManagerReportGeneratorsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseSpecificationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicenseVersionsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListLicensesRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedGrantsForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedGrantsRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedLicensesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListReceivedLicensesRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListResourceInventoryRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListTokensRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.ListUsageForLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.RejectGrantRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateLicenseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateLicenseManagerReportGeneratorRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateLicenseSpecificationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.licensemanager.transform.UpdateServiceSettingsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLicenseManagerClient
implements LicenseManagerClient {
    private static final Logger log = Logger.loggerFor(DefaultLicenseManagerClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLicenseManagerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "license-manager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptGrantResponse acceptGrant(AcceptGrantRequest acceptGrantRequest) throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, acceptGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptGrant");
            AcceptGrantResponse acceptGrantResponse = (AcceptGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$acceptGrant$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckInLicenseResponse checkInLicense(CheckInLicenseRequest checkInLicenseRequest) throws ValidationException, InvalidParameterValueException, ResourceNotFoundException, ConflictException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckInLicenseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, checkInLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckInLicense");
            CheckInLicenseResponse checkInLicenseResponse = (CheckInLicenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckInLicense").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkInLicenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CheckInLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return checkInLicenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$checkInLicense$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckoutBorrowLicenseResponse checkoutBorrowLicense(CheckoutBorrowLicenseRequest checkoutBorrowLicenseRequest) throws ValidationException, InvalidParameterValueException, ResourceNotFoundException, NoEntitlementsAllowedException, EntitlementNotAllowedException, UnsupportedDigitalSignatureMethodException, RedirectException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckoutBorrowLicenseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, checkoutBorrowLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckoutBorrowLicense");
            CheckoutBorrowLicenseResponse checkoutBorrowLicenseResponse = (CheckoutBorrowLicenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckoutBorrowLicense").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkoutBorrowLicenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CheckoutBorrowLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return checkoutBorrowLicenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$checkoutBorrowLicense$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckoutLicenseResponse checkoutLicense(CheckoutLicenseRequest checkoutLicenseRequest) throws ValidationException, InvalidParameterValueException, ResourceNotFoundException, NoEntitlementsAllowedException, UnsupportedDigitalSignatureMethodException, RedirectException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckoutLicenseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, checkoutLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckoutLicense");
            CheckoutLicenseResponse checkoutLicenseResponse = (CheckoutLicenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckoutLicense").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkoutLicenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CheckoutLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return checkoutLicenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$checkoutLicense$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGrantResponse createGrant(CreateGrantRequest createGrantRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, RateLimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGrant");
            CreateGrantResponse createGrantResponse = (CreateGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createGrant$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGrantVersionResponse createGrantVersion(CreateGrantVersionRequest createGrantVersionRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGrantVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createGrantVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGrantVersion");
            CreateGrantVersionResponse createGrantVersionResponse = (CreateGrantVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGrantVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGrantVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGrantVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGrantVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createGrantVersion$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLicenseResponse createLicense(CreateLicenseRequest createLicenseRequest) throws ValidationException, InvalidParameterValueException, RedirectException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicense");
            CreateLicenseResponse createLicenseResponse = (CreateLicenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicense").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLicenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLicenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createLicense$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLicenseConfigurationResponse createLicenseConfiguration(CreateLicenseConfigurationRequest createLicenseConfigurationRequest) throws InvalidParameterValueException, ServerInternalException, ResourceLimitExceededException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseConfiguration");
            CreateLicenseConfigurationResponse createLicenseConfigurationResponse = (CreateLicenseConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLicenseConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLicenseConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createLicenseConfiguration$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLicenseConversionTaskForResourceResponse createLicenseConversionTaskForResource(CreateLicenseConversionTaskForResourceRequest createLicenseConversionTaskForResourceRequest) throws InvalidParameterValueException, ValidationException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseConversionTaskForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createLicenseConversionTaskForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseConversionTaskForResource");
            CreateLicenseConversionTaskForResourceResponse createLicenseConversionTaskForResourceResponse = (CreateLicenseConversionTaskForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseConversionTaskForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLicenseConversionTaskForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLicenseConversionTaskForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLicenseConversionTaskForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createLicenseConversionTaskForResource$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLicenseManagerReportGeneratorResponse createLicenseManagerReportGenerator(CreateLicenseManagerReportGeneratorRequest createLicenseManagerReportGeneratorRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseManagerReportGeneratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseManagerReportGenerator");
            CreateLicenseManagerReportGeneratorResponse createLicenseManagerReportGeneratorResponse = (CreateLicenseManagerReportGeneratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseManagerReportGenerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLicenseManagerReportGeneratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLicenseManagerReportGeneratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createLicenseManagerReportGenerator$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLicenseVersionResponse createLicenseVersion(CreateLicenseVersionRequest createLicenseVersionRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, RedirectException, ConflictException, ServerInternalException, AuthorizationException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLicenseVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createLicenseVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLicenseVersion");
            CreateLicenseVersionResponse createLicenseVersionResponse = (CreateLicenseVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLicenseVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLicenseVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLicenseVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLicenseVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createLicenseVersion$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTokenResponse createToken(CreateTokenRequest createTokenRequest) throws ValidationException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ResourceLimitExceededException, ServerInternalException, ResourceNotFoundException, RedirectException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, createTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateToken");
            CreateTokenResponse createTokenResponse = (CreateTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$createToken$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGrantResponse deleteGrant(DeleteGrantRequest deleteGrantRequest) throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGrant");
            DeleteGrantResponse deleteGrantResponse = (DeleteGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$deleteGrant$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLicenseResponse deleteLicense(DeleteLicenseRequest deleteLicenseRequest) throws ValidationException, InvalidParameterValueException, RedirectException, ConflictException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLicenseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLicense");
            DeleteLicenseResponse deleteLicenseResponse = (DeleteLicenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLicense").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLicenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLicenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$deleteLicense$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLicenseConfigurationResponse deleteLicenseConfiguration(DeleteLicenseConfigurationRequest deleteLicenseConfigurationRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLicenseConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLicenseConfiguration");
            DeleteLicenseConfigurationResponse deleteLicenseConfigurationResponse = (DeleteLicenseConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLicenseConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLicenseConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLicenseConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$deleteLicenseConfiguration$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLicenseManagerReportGeneratorResponse deleteLicenseManagerReportGenerator(DeleteLicenseManagerReportGeneratorRequest deleteLicenseManagerReportGeneratorRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLicenseManagerReportGeneratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLicenseManagerReportGenerator");
            DeleteLicenseManagerReportGeneratorResponse deleteLicenseManagerReportGeneratorResponse = (DeleteLicenseManagerReportGeneratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLicenseManagerReportGenerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLicenseManagerReportGeneratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLicenseManagerReportGeneratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$deleteLicenseManagerReportGenerator$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTokenResponse deleteToken(DeleteTokenRequest deleteTokenRequest) throws ValidationException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, ResourceNotFoundException, RedirectException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, deleteTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteToken");
            DeleteTokenResponse deleteTokenResponse = (DeleteTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$deleteToken$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendLicenseConsumptionResponse extendLicenseConsumption(ExtendLicenseConsumptionRequest extendLicenseConsumptionRequest) throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExtendLicenseConsumptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, extendLicenseConsumptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExtendLicenseConsumption");
            ExtendLicenseConsumptionResponse extendLicenseConsumptionResponse = (ExtendLicenseConsumptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExtendLicenseConsumption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)extendLicenseConsumptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExtendLicenseConsumptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return extendLicenseConsumptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$extendLicenseConsumption$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessTokenResponse getAccessToken(GetAccessTokenRequest getAccessTokenRequest) throws ValidationException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccessTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getAccessTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessToken");
            GetAccessTokenResponse getAccessTokenResponse = (GetAccessTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccessTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccessTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccessTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getAccessToken$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGrantResponse getGrant(GetGrantRequest getGrantRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGrant");
            GetGrantResponse getGrantResponse = (GetGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getGrant$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLicenseResponse getLicense(GetLicenseRequest getLicenseRequest) throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getLicenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicense");
            GetLicenseResponse getLicenseResponse = (GetLicenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicense").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLicenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLicenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLicenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getLicense$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLicenseConfigurationResponse getLicenseConfiguration(GetLicenseConfigurationRequest getLicenseConfigurationRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseConfiguration");
            GetLicenseConfigurationResponse getLicenseConfigurationResponse = (GetLicenseConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLicenseConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLicenseConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getLicenseConfiguration$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLicenseConversionTaskResponse getLicenseConversionTask(GetLicenseConversionTaskRequest getLicenseConversionTaskRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseConversionTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getLicenseConversionTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseConversionTask");
            GetLicenseConversionTaskResponse getLicenseConversionTaskResponse = (GetLicenseConversionTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseConversionTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLicenseConversionTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLicenseConversionTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLicenseConversionTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getLicenseConversionTask$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLicenseManagerReportGeneratorResponse getLicenseManagerReportGenerator(GetLicenseManagerReportGeneratorRequest getLicenseManagerReportGeneratorRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseManagerReportGeneratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseManagerReportGenerator");
            GetLicenseManagerReportGeneratorResponse getLicenseManagerReportGeneratorResponse = (GetLicenseManagerReportGeneratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseManagerReportGenerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLicenseManagerReportGeneratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLicenseManagerReportGeneratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getLicenseManagerReportGenerator$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLicenseUsageResponse getLicenseUsage(GetLicenseUsageRequest getLicenseUsageRequest) throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLicenseUsageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getLicenseUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLicenseUsage");
            GetLicenseUsageResponse getLicenseUsageResponse = (GetLicenseUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLicenseUsage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLicenseUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLicenseUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLicenseUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getLicenseUsage$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceSettingsResponse getServiceSettings(GetServiceSettingsRequest getServiceSettingsRequest) throws ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, getServiceSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceSettings");
            GetServiceSettingsResponse getServiceSettingsResponse = (GetServiceSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$getServiceSettings$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssociationsForLicenseConfigurationResponse listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest listAssociationsForLicenseConfigurationRequest) throws InvalidParameterValueException, FilterLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssociationsForLicenseConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listAssociationsForLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssociationsForLicenseConfiguration");
            ListAssociationsForLicenseConfigurationResponse listAssociationsForLicenseConfigurationResponse = (ListAssociationsForLicenseConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssociationsForLicenseConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssociationsForLicenseConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAssociationsForLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssociationsForLicenseConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listAssociationsForLicenseConfiguration$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDistributedGrantsResponse listDistributedGrants(ListDistributedGrantsRequest listDistributedGrantsRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDistributedGrantsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listDistributedGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributedGrants");
            ListDistributedGrantsResponse listDistributedGrantsResponse = (ListDistributedGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributedGrants").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDistributedGrantsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDistributedGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDistributedGrantsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listDistributedGrants$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFailuresForLicenseConfigurationOperationsResponse listFailuresForLicenseConfigurationOperations(ListFailuresForLicenseConfigurationOperationsRequest listFailuresForLicenseConfigurationOperationsRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFailuresForLicenseConfigurationOperationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listFailuresForLicenseConfigurationOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFailuresForLicenseConfigurationOperations");
            ListFailuresForLicenseConfigurationOperationsResponse listFailuresForLicenseConfigurationOperationsResponse = (ListFailuresForLicenseConfigurationOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFailuresForLicenseConfigurationOperations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFailuresForLicenseConfigurationOperationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFailuresForLicenseConfigurationOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFailuresForLicenseConfigurationOperationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listFailuresForLicenseConfigurationOperations$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLicenseConfigurationsResponse listLicenseConfigurations(ListLicenseConfigurationsRequest listLicenseConfigurationsRequest) throws InvalidParameterValueException, ServerInternalException, FilterLimitExceededException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listLicenseConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseConfigurations");
            ListLicenseConfigurationsResponse listLicenseConfigurationsResponse = (ListLicenseConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLicenseConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLicenseConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLicenseConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listLicenseConfigurations$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLicenseConversionTasksResponse listLicenseConversionTasks(ListLicenseConversionTasksRequest listLicenseConversionTasksRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseConversionTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listLicenseConversionTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseConversionTasks");
            ListLicenseConversionTasksResponse listLicenseConversionTasksResponse = (ListLicenseConversionTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseConversionTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLicenseConversionTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLicenseConversionTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLicenseConversionTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listLicenseConversionTasks$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLicenseManagerReportGeneratorsResponse listLicenseManagerReportGenerators(ListLicenseManagerReportGeneratorsRequest listLicenseManagerReportGeneratorsRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, RateLimitExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseManagerReportGeneratorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listLicenseManagerReportGeneratorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseManagerReportGenerators");
            ListLicenseManagerReportGeneratorsResponse listLicenseManagerReportGeneratorsResponse = (ListLicenseManagerReportGeneratorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseManagerReportGenerators").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLicenseManagerReportGeneratorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLicenseManagerReportGeneratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLicenseManagerReportGeneratorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listLicenseManagerReportGenerators$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLicenseSpecificationsForResourceResponse listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest listLicenseSpecificationsForResourceRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseSpecificationsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listLicenseSpecificationsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseSpecificationsForResource");
            ListLicenseSpecificationsForResourceResponse listLicenseSpecificationsForResourceResponse = (ListLicenseSpecificationsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseSpecificationsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLicenseSpecificationsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLicenseSpecificationsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLicenseSpecificationsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listLicenseSpecificationsForResource$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLicenseVersionsResponse listLicenseVersions(ListLicenseVersionsRequest listLicenseVersionsRequest) throws InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicenseVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listLicenseVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenseVersions");
            ListLicenseVersionsResponse listLicenseVersionsResponse = (ListLicenseVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenseVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLicenseVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLicenseVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLicenseVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listLicenseVersions$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLicensesResponse listLicenses(ListLicensesRequest listLicensesRequest) throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLicensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listLicensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLicenses");
            ListLicensesResponse listLicensesResponse = (ListLicensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLicenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLicensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLicensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLicensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listLicenses$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReceivedGrantsResponse listReceivedGrants(ListReceivedGrantsRequest listReceivedGrantsRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedGrantsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listReceivedGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedGrants");
            ListReceivedGrantsResponse listReceivedGrantsResponse = (ListReceivedGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedGrants").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceivedGrantsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReceivedGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReceivedGrantsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listReceivedGrants$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReceivedGrantsForOrganizationResponse listReceivedGrantsForOrganization(ListReceivedGrantsForOrganizationRequest listReceivedGrantsForOrganizationRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedGrantsForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listReceivedGrantsForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedGrantsForOrganization");
            ListReceivedGrantsForOrganizationResponse listReceivedGrantsForOrganizationResponse = (ListReceivedGrantsForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedGrantsForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceivedGrantsForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReceivedGrantsForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReceivedGrantsForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listReceivedGrantsForOrganization$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReceivedLicensesResponse listReceivedLicenses(ListReceivedLicensesRequest listReceivedLicensesRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedLicensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listReceivedLicensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedLicenses");
            ListReceivedLicensesResponse listReceivedLicensesResponse = (ListReceivedLicensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedLicenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceivedLicensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReceivedLicensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReceivedLicensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listReceivedLicenses$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReceivedLicensesForOrganizationResponse listReceivedLicensesForOrganization(ListReceivedLicensesForOrganizationRequest listReceivedLicensesForOrganizationRequest) throws ValidationException, InvalidParameterValueException, ResourceLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReceivedLicensesForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listReceivedLicensesForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReceivedLicensesForOrganization");
            ListReceivedLicensesForOrganizationResponse listReceivedLicensesForOrganizationResponse = (ListReceivedLicensesForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceivedLicensesForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceivedLicensesForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReceivedLicensesForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReceivedLicensesForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listReceivedLicensesForOrganization$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceInventoryResponse listResourceInventory(ListResourceInventoryRequest listResourceInventoryRequest) throws InvalidParameterValueException, ServerInternalException, FilterLimitExceededException, FailedDependencyException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceInventoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listResourceInventoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceInventory");
            ListResourceInventoryResponse listResourceInventoryResponse = (ListResourceInventoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceInventory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceInventoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceInventoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceInventoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listResourceInventory$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listTagsForResource$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTokensResponse listTokens(ListTokensRequest listTokensRequest) throws ValidationException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTokensResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listTokensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTokens");
            ListTokensResponse listTokensResponse = (ListTokensResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTokens").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTokensRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTokensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTokensResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listTokens$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsageForLicenseConfigurationResponse listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest listUsageForLicenseConfigurationRequest) throws InvalidParameterValueException, FilterLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsageForLicenseConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, listUsageForLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsageForLicenseConfiguration");
            ListUsageForLicenseConfigurationResponse listUsageForLicenseConfigurationResponse = (ListUsageForLicenseConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsageForLicenseConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsageForLicenseConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsageForLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsageForLicenseConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$listUsageForLicenseConfiguration$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectGrantResponse rejectGrant(RejectGrantRequest rejectGrantRequest) throws ValidationException, InvalidParameterValueException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ResourceLimitExceededException, ServerInternalException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, rejectGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectGrant");
            RejectGrantResponse rejectGrantResponse = (RejectGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$rejectGrant$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$tagResource$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$untagResource$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLicenseConfigurationResponse updateLicenseConfiguration(UpdateLicenseConfigurationRequest updateLicenseConfigurationRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, ResourceLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLicenseConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, updateLicenseConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLicenseConfiguration");
            UpdateLicenseConfigurationResponse updateLicenseConfigurationResponse = (UpdateLicenseConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLicenseConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLicenseConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLicenseConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLicenseConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$updateLicenseConfiguration$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLicenseManagerReportGeneratorResponse updateLicenseManagerReportGenerator(UpdateLicenseManagerReportGeneratorRequest updateLicenseManagerReportGeneratorRequest) throws ValidationException, InvalidParameterValueException, RateLimitExceededException, ServerInternalException, AuthorizationException, AccessDeniedException, ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLicenseManagerReportGeneratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, updateLicenseManagerReportGeneratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLicenseManagerReportGenerator");
            UpdateLicenseManagerReportGeneratorResponse updateLicenseManagerReportGeneratorResponse = (UpdateLicenseManagerReportGeneratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLicenseManagerReportGenerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLicenseManagerReportGeneratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLicenseManagerReportGeneratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLicenseManagerReportGeneratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$updateLicenseManagerReportGenerator$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLicenseSpecificationsForResourceResponse updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest updateLicenseSpecificationsForResourceRequest) throws InvalidParameterValueException, InvalidResourceStateException, LicenseUsageException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLicenseSpecificationsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, updateLicenseSpecificationsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLicenseSpecificationsForResource");
            UpdateLicenseSpecificationsForResourceResponse updateLicenseSpecificationsForResourceResponse = (UpdateLicenseSpecificationsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLicenseSpecificationsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLicenseSpecificationsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLicenseSpecificationsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLicenseSpecificationsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$updateLicenseSpecificationsForResource$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceSettingsResponse updateServiceSettings(UpdateServiceSettingsRequest updateServiceSettingsRequest) throws InvalidParameterValueException, ServerInternalException, AuthorizationException, AccessDeniedException, RateLimitExceededException, AwsServiceException, SdkClientException, LicenseManagerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLicenseManagerClient.resolveMetricPublishers(this.clientConfiguration, updateServiceSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"License Manager");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceSettings");
            UpdateServiceSettingsResponse updateServiceSettingsResponse = (UpdateServiceSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLicenseManagerClient.lambda$updateServiceSettings$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LicenseManagerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("FailedDependencyException").exceptionBuilderSupplier(FailedDependencyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RateLimitExceededException").exceptionBuilderSupplier(RateLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FilterLimitExceededException").exceptionBuilderSupplier(FilterLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServerInternalException").exceptionBuilderSupplier(ServerInternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RedirectException").exceptionBuilderSupplier(RedirectException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedDigitalSignatureMethodException").exceptionBuilderSupplier(UnsupportedDigitalSignatureMethodException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationException").exceptionBuilderSupplier(AuthorizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").exceptionBuilderSupplier(InvalidResourceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntitlementNotAllowedException").exceptionBuilderSupplier(EntitlementNotAllowedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoEntitlementsAllowedException").exceptionBuilderSupplier(NoEntitlementsAllowedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LicenseUsageException").exceptionBuilderSupplier(LicenseUsageException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateServiceSettings$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLicenseSpecificationsForResource$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLicenseManagerReportGenerator$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLicenseConfiguration$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectGrant$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsageForLicenseConfiguration$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTokens$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceInventory$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedLicensesForOrganization$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedLicenses$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedGrantsForOrganization$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReceivedGrants$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenses$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseVersions$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseSpecificationsForResource$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseManagerReportGenerators$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseConversionTasks$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLicenseConfigurations$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFailuresForLicenseConfigurationOperations$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributedGrants$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssociationsForLicenseConfiguration$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceSettings$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseUsage$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseManagerReportGenerator$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseConversionTask$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicenseConfiguration$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLicense$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGrant$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessToken$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$extendLicenseConsumption$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteToken$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLicenseManagerReportGenerator$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLicenseConfiguration$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLicense$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGrant$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createToken$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseVersion$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseManagerReportGenerator$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseConversionTaskForResource$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicenseConfiguration$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLicense$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGrantVersion$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGrant$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkoutLicense$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkoutBorrowLicense$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkInLicense$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptGrant$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

