/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LicenseCountingType {
    V_CPU("vCPU"),
    INSTANCE("Instance"),
    CORE("Core"),
    SOCKET("Socket"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LicenseCountingType> VALUE_MAP;
    private final String value;

    private LicenseCountingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LicenseCountingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LicenseCountingType> knownValues() {
        EnumSet<LicenseCountingType> knownValues = EnumSet.allOf(LicenseCountingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LicenseCountingType.class, LicenseCountingType::toString);
    }
}

