/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ArnListCopier;
import software.amazon.awssdk.services.licensemanager.model.MaxSize3StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TokenData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TokenData> {
    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenId").getter(TokenData.getter(TokenData::tokenId)).setter(TokenData.setter(Builder::tokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenId").build()}).build();
    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenType").getter(TokenData.getter(TokenData::tokenType)).setter(TokenData.setter(Builder::tokenType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenType").build()}).build();
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(TokenData.getter(TokenData::licenseArn)).setter(TokenData.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<String> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationTime").getter(TokenData.getter(TokenData::expirationTime)).setter(TokenData.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()}).build();
    private static final SdkField<List<String>> TOKEN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenProperties").getter(TokenData.getter(TokenData::tokenProperties)).setter(TokenData.setter(Builder::tokenProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoleArns").getter(TokenData.getter(TokenData::roleArns)).setter(TokenData.setter(Builder::roleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TokenData.getter(TokenData::status)).setter(TokenData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_ID_FIELD, TOKEN_TYPE_FIELD, LICENSE_ARN_FIELD, EXPIRATION_TIME_FIELD, TOKEN_PROPERTIES_FIELD, ROLE_ARNS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tokenId;
    private final String tokenType;
    private final String licenseArn;
    private final String expirationTime;
    private final List<String> tokenProperties;
    private final List<String> roleArns;
    private final String status;

    private TokenData(BuilderImpl builder) {
        this.tokenId = builder.tokenId;
        this.tokenType = builder.tokenType;
        this.licenseArn = builder.licenseArn;
        this.expirationTime = builder.expirationTime;
        this.tokenProperties = builder.tokenProperties;
        this.roleArns = builder.roleArns;
        this.status = builder.status;
    }

    public final String tokenId() {
        return this.tokenId;
    }

    public final String tokenType() {
        return this.tokenType;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final String expirationTime() {
        return this.expirationTime;
    }

    public final boolean hasTokenProperties() {
        return this.tokenProperties != null && !(this.tokenProperties instanceof SdkAutoConstructList);
    }

    public final List<String> tokenProperties() {
        return this.tokenProperties;
    }

    public final boolean hasRoleArns() {
        return this.roleArns != null && !(this.roleArns instanceof SdkAutoConstructList);
    }

    public final List<String> roleArns() {
        return this.roleArns;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenProperties() ? this.tokenProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleArns() ? this.roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenData)) {
            return false;
        }
        TokenData other = (TokenData)obj;
        return Objects.equals(this.tokenId(), other.tokenId()) && Objects.equals(this.tokenType(), other.tokenType()) && Objects.equals(this.licenseArn(), other.licenseArn()) && Objects.equals(this.expirationTime(), other.expirationTime()) && this.hasTokenProperties() == other.hasTokenProperties() && Objects.equals(this.tokenProperties(), other.tokenProperties()) && this.hasRoleArns() == other.hasRoleArns() && Objects.equals(this.roleArns(), other.roleArns()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"TokenData").add("TokenId", (Object)this.tokenId()).add("TokenType", (Object)this.tokenType()).add("LicenseArn", (Object)this.licenseArn()).add("ExpirationTime", (Object)this.expirationTime()).add("TokenProperties", this.hasTokenProperties() ? this.tokenProperties() : null).add("RoleArns", this.hasRoleArns() ? this.roleArns() : null).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TokenId": {
                return Optional.ofNullable(clazz.cast(this.tokenId()));
            }
            case "TokenType": {
                return Optional.ofNullable(clazz.cast(this.tokenType()));
            }
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "TokenProperties": {
                return Optional.ofNullable(clazz.cast(this.tokenProperties()));
            }
            case "RoleArns": {
                return Optional.ofNullable(clazz.cast(this.roleArns()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TokenData, T> g) {
        return obj -> g.apply((TokenData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tokenId;
        private String tokenType;
        private String licenseArn;
        private String expirationTime;
        private List<String> tokenProperties = DefaultSdkAutoConstructList.getInstance();
        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TokenData model) {
            this.tokenId(model.tokenId);
            this.tokenType(model.tokenType);
            this.licenseArn(model.licenseArn);
            this.expirationTime(model.expirationTime);
            this.tokenProperties(model.tokenProperties);
            this.roleArns(model.roleArns);
            this.status(model.status);
        }

        public final String getTokenId() {
            return this.tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getTokenType() {
            return this.tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final Collection<String> getTokenProperties() {
            if (this.tokenProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenProperties;
        }

        public final void setTokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
        }

        @Override
        public final Builder tokenProperties(Collection<String> tokenProperties) {
            this.tokenProperties = MaxSize3StringListCopier.copy(tokenProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenProperties(String ... tokenProperties) {
            this.tokenProperties(Arrays.asList(tokenProperties));
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (this.roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = ArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String ... roleArns) {
            this.roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public TokenData build() {
            return new TokenData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TokenData> {
        public Builder tokenId(String var1);

        public Builder tokenType(String var1);

        public Builder licenseArn(String var1);

        public Builder expirationTime(String var1);

        public Builder tokenProperties(Collection<String> var1);

        public Builder tokenProperties(String ... var1);

        public Builder roleArns(Collection<String> var1);

        public Builder roleArns(String ... var1);

        public Builder status(String var1);
    }
}

