/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.ReportGenerator;
import software.amazon.awssdk.services.licensemanager.model.ReportGeneratorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLicenseManagerReportGeneratorsResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListLicenseManagerReportGeneratorsResponse> {
    private static final SdkField<List<ReportGenerator>> REPORT_GENERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReportGenerators").getter(ListLicenseManagerReportGeneratorsResponse.getter(ListLicenseManagerReportGeneratorsResponse::reportGenerators)).setter(ListLicenseManagerReportGeneratorsResponse.setter(Builder::reportGenerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGenerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportGenerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLicenseManagerReportGeneratorsResponse.getter(ListLicenseManagerReportGeneratorsResponse::nextToken)).setter(ListLicenseManagerReportGeneratorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GENERATORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ReportGenerator> reportGenerators;
    private final String nextToken;

    private ListLicenseManagerReportGeneratorsResponse(BuilderImpl builder) {
        super(builder);
        this.reportGenerators = builder.reportGenerators;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReportGenerators() {
        return this.reportGenerators != null && !(this.reportGenerators instanceof SdkAutoConstructList);
    }

    public final List<ReportGenerator> reportGenerators() {
        return this.reportGenerators;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportGenerators() ? this.reportGenerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseManagerReportGeneratorsResponse)) {
            return false;
        }
        ListLicenseManagerReportGeneratorsResponse other = (ListLicenseManagerReportGeneratorsResponse)((Object)obj);
        return this.hasReportGenerators() == other.hasReportGenerators() && Objects.equals(this.reportGenerators(), other.reportGenerators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLicenseManagerReportGeneratorsResponse").add("ReportGenerators", this.hasReportGenerators() ? this.reportGenerators() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportGenerators": {
                return Optional.ofNullable(clazz.cast(this.reportGenerators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseManagerReportGeneratorsResponse, T> g) {
        return obj -> g.apply((ListLicenseManagerReportGeneratorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<ReportGenerator> reportGenerators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseManagerReportGeneratorsResponse model) {
            super(model);
            this.reportGenerators(model.reportGenerators);
            this.nextToken(model.nextToken);
        }

        public final List<ReportGenerator.Builder> getReportGenerators() {
            List<ReportGenerator.Builder> result = ReportGeneratorListCopier.copyToBuilder(this.reportGenerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportGenerators(Collection<ReportGenerator.BuilderImpl> reportGenerators) {
            this.reportGenerators = ReportGeneratorListCopier.copyFromBuilder(reportGenerators);
        }

        @Override
        public final Builder reportGenerators(Collection<ReportGenerator> reportGenerators) {
            this.reportGenerators = ReportGeneratorListCopier.copy(reportGenerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGenerators(ReportGenerator ... reportGenerators) {
            this.reportGenerators(Arrays.asList(reportGenerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGenerators(Consumer<ReportGenerator.Builder> ... reportGenerators) {
            this.reportGenerators(Stream.of(reportGenerators).map(c -> (ReportGenerator)((ReportGenerator.Builder)ReportGenerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLicenseManagerReportGeneratorsResponse build() {
            return new ListLicenseManagerReportGeneratorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLicenseManagerReportGeneratorsResponse> {
        public Builder reportGenerators(Collection<ReportGenerator> var1);

        public Builder reportGenerators(ReportGenerator ... var1);

        public Builder reportGenerators(Consumer<ReportGenerator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

