/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GrantStatus {
    PENDING_WORKFLOW("PENDING_WORKFLOW"),
    PENDING_ACCEPT("PENDING_ACCEPT"),
    REJECTED("REJECTED"),
    ACTIVE("ACTIVE"),
    FAILED_WORKFLOW("FAILED_WORKFLOW"),
    DELETED("DELETED"),
    PENDING_DELETE("PENDING_DELETE"),
    DISABLED("DISABLED"),
    WORKFLOW_COMPLETED("WORKFLOW_COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GrantStatus> VALUE_MAP;
    private final String value;

    private GrantStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GrantStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GrantStatus> knownValues() {
        EnumSet<GrantStatus> knownValues = EnumSet.allOf(GrantStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GrantStatus.class, GrantStatus::toString);
    }
}

