/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntitlementDataUnit {
    COUNT("Count"),
    NONE("None"),
    SECONDS("Seconds"),
    MICROSECONDS("Microseconds"),
    MILLISECONDS("Milliseconds"),
    BYTES("Bytes"),
    KILOBYTES("Kilobytes"),
    MEGABYTES("Megabytes"),
    GIGABYTES("Gigabytes"),
    TERABYTES("Terabytes"),
    BITS("Bits"),
    KILOBITS("Kilobits"),
    MEGABITS("Megabits"),
    GIGABITS("Gigabits"),
    TERABITS("Terabits"),
    PERCENT("Percent"),
    BYTES_SECOND("Bytes/Second"),
    KILOBYTES_SECOND("Kilobytes/Second"),
    MEGABYTES_SECOND("Megabytes/Second"),
    GIGABYTES_SECOND("Gigabytes/Second"),
    TERABYTES_SECOND("Terabytes/Second"),
    BITS_SECOND("Bits/Second"),
    KILOBITS_SECOND("Kilobits/Second"),
    MEGABITS_SECOND("Megabits/Second"),
    GIGABITS_SECOND("Gigabits/Second"),
    TERABITS_SECOND("Terabits/Second"),
    COUNT_SECOND("Count/Second"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntitlementDataUnit> VALUE_MAP;
    private final String value;

    private EntitlementDataUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntitlementDataUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntitlementDataUnit> knownValues() {
        EnumSet<EntitlementDataUnit> knownValues = EnumSet.allOf(EntitlementDataUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntitlementDataUnit.class, EntitlementDataUnit::toString);
    }
}

