/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ReportContext;
import software.amazon.awssdk.services.licensemanager.model.ReportFrequency;
import software.amazon.awssdk.services.licensemanager.model.ReportType;
import software.amazon.awssdk.services.licensemanager.model.ReportTypeListCopier;
import software.amazon.awssdk.services.licensemanager.model.S3Location;
import software.amazon.awssdk.services.licensemanager.model.Tag;
import software.amazon.awssdk.services.licensemanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportGenerator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportGenerator> {
    private static final SdkField<String> REPORT_GENERATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportGeneratorName").getter(ReportGenerator.getter(ReportGenerator::reportGeneratorName)).setter(ReportGenerator.setter(Builder::reportGeneratorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGeneratorName").build()}).build();
    private static final SdkField<List<String>> REPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReportType").getter(ReportGenerator.getter(ReportGenerator::reportTypeAsStrings)).setter(ReportGenerator.setter(Builder::reportTypeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReportContext> REPORT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportContext").getter(ReportGenerator.getter(ReportGenerator::reportContext)).setter(ReportGenerator.setter(Builder::reportContext)).constructor(ReportContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportContext").build()}).build();
    private static final SdkField<ReportFrequency> REPORT_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportFrequency").getter(ReportGenerator.getter(ReportGenerator::reportFrequency)).setter(ReportGenerator.setter(Builder::reportFrequency)).constructor(ReportFrequency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportFrequency").build()}).build();
    private static final SdkField<String> LICENSE_MANAGER_REPORT_GENERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseManagerReportGeneratorArn").getter(ReportGenerator.getter(ReportGenerator::licenseManagerReportGeneratorArn)).setter(ReportGenerator.setter(Builder::licenseManagerReportGeneratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseManagerReportGeneratorArn").build()}).build();
    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRunStatus").getter(ReportGenerator.getter(ReportGenerator::lastRunStatus)).setter(ReportGenerator.setter(Builder::lastRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunStatus").build()}).build();
    private static final SdkField<String> LAST_RUN_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRunFailureReason").getter(ReportGenerator.getter(ReportGenerator::lastRunFailureReason)).setter(ReportGenerator.setter(Builder::lastRunFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunFailureReason").build()}).build();
    private static final SdkField<String> LAST_REPORT_GENERATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastReportGenerationTime").getter(ReportGenerator.getter(ReportGenerator::lastReportGenerationTime)).setter(ReportGenerator.setter(Builder::lastReportGenerationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastReportGenerationTime").build()}).build();
    private static final SdkField<String> REPORT_CREATOR_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportCreatorAccount").getter(ReportGenerator.getter(ReportGenerator::reportCreatorAccount)).setter(ReportGenerator.setter(Builder::reportCreatorAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportCreatorAccount").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReportGenerator.getter(ReportGenerator::description)).setter(ReportGenerator.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Location").getter(ReportGenerator.getter(ReportGenerator::s3Location)).setter(ReportGenerator.setter(Builder::s3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location").build()}).build();
    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateTime").getter(ReportGenerator.getter(ReportGenerator::createTime)).setter(ReportGenerator.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ReportGenerator.getter(ReportGenerator::tags)).setter(ReportGenerator.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GENERATOR_NAME_FIELD, REPORT_TYPE_FIELD, REPORT_CONTEXT_FIELD, REPORT_FREQUENCY_FIELD, LICENSE_MANAGER_REPORT_GENERATOR_ARN_FIELD, LAST_RUN_STATUS_FIELD, LAST_RUN_FAILURE_REASON_FIELD, LAST_REPORT_GENERATION_TIME_FIELD, REPORT_CREATOR_ACCOUNT_FIELD, DESCRIPTION_FIELD, S3_LOCATION_FIELD, CREATE_TIME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reportGeneratorName;
    private final List<String> reportType;
    private final ReportContext reportContext;
    private final ReportFrequency reportFrequency;
    private final String licenseManagerReportGeneratorArn;
    private final String lastRunStatus;
    private final String lastRunFailureReason;
    private final String lastReportGenerationTime;
    private final String reportCreatorAccount;
    private final String description;
    private final S3Location s3Location;
    private final String createTime;
    private final List<Tag> tags;

    private ReportGenerator(BuilderImpl builder) {
        this.reportGeneratorName = builder.reportGeneratorName;
        this.reportType = builder.reportType;
        this.reportContext = builder.reportContext;
        this.reportFrequency = builder.reportFrequency;
        this.licenseManagerReportGeneratorArn = builder.licenseManagerReportGeneratorArn;
        this.lastRunStatus = builder.lastRunStatus;
        this.lastRunFailureReason = builder.lastRunFailureReason;
        this.lastReportGenerationTime = builder.lastReportGenerationTime;
        this.reportCreatorAccount = builder.reportCreatorAccount;
        this.description = builder.description;
        this.s3Location = builder.s3Location;
        this.createTime = builder.createTime;
        this.tags = builder.tags;
    }

    public final String reportGeneratorName() {
        return this.reportGeneratorName;
    }

    public final List<ReportType> reportType() {
        return ReportTypeListCopier.copyStringToEnum(this.reportType);
    }

    public final boolean hasReportType() {
        return this.reportType != null && !(this.reportType instanceof SdkAutoConstructList);
    }

    public final List<String> reportTypeAsStrings() {
        return this.reportType;
    }

    public final ReportContext reportContext() {
        return this.reportContext;
    }

    public final ReportFrequency reportFrequency() {
        return this.reportFrequency;
    }

    public final String licenseManagerReportGeneratorArn() {
        return this.licenseManagerReportGeneratorArn;
    }

    public final String lastRunStatus() {
        return this.lastRunStatus;
    }

    public final String lastRunFailureReason() {
        return this.lastRunFailureReason;
    }

    public final String lastReportGenerationTime() {
        return this.lastReportGenerationTime;
    }

    public final String reportCreatorAccount() {
        return this.reportCreatorAccount;
    }

    public final String description() {
        return this.description;
    }

    public final S3Location s3Location() {
        return this.s3Location;
    }

    public final String createTime() {
        return this.createTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportGeneratorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportType() ? this.reportTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseManagerReportGeneratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunFailureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastReportGenerationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportCreatorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportGenerator)) {
            return false;
        }
        ReportGenerator other = (ReportGenerator)obj;
        return Objects.equals(this.reportGeneratorName(), other.reportGeneratorName()) && this.hasReportType() == other.hasReportType() && Objects.equals(this.reportTypeAsStrings(), other.reportTypeAsStrings()) && Objects.equals(this.reportContext(), other.reportContext()) && Objects.equals(this.reportFrequency(), other.reportFrequency()) && Objects.equals(this.licenseManagerReportGeneratorArn(), other.licenseManagerReportGeneratorArn()) && Objects.equals(this.lastRunStatus(), other.lastRunStatus()) && Objects.equals(this.lastRunFailureReason(), other.lastRunFailureReason()) && Objects.equals(this.lastReportGenerationTime(), other.lastReportGenerationTime()) && Objects.equals(this.reportCreatorAccount(), other.reportCreatorAccount()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.createTime(), other.createTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ReportGenerator").add("ReportGeneratorName", (Object)this.reportGeneratorName()).add("ReportType", this.hasReportType() ? this.reportTypeAsStrings() : null).add("ReportContext", (Object)this.reportContext()).add("ReportFrequency", (Object)this.reportFrequency()).add("LicenseManagerReportGeneratorArn", (Object)this.licenseManagerReportGeneratorArn()).add("LastRunStatus", (Object)this.lastRunStatus()).add("LastRunFailureReason", (Object)this.lastRunFailureReason()).add("LastReportGenerationTime", (Object)this.lastReportGenerationTime()).add("ReportCreatorAccount", (Object)this.reportCreatorAccount()).add("Description", (Object)this.description()).add("S3Location", (Object)this.s3Location()).add("CreateTime", (Object)this.createTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportGeneratorName": {
                return Optional.ofNullable(clazz.cast(this.reportGeneratorName()));
            }
            case "ReportType": {
                return Optional.ofNullable(clazz.cast(this.reportTypeAsStrings()));
            }
            case "ReportContext": {
                return Optional.ofNullable(clazz.cast(this.reportContext()));
            }
            case "ReportFrequency": {
                return Optional.ofNullable(clazz.cast(this.reportFrequency()));
            }
            case "LicenseManagerReportGeneratorArn": {
                return Optional.ofNullable(clazz.cast(this.licenseManagerReportGeneratorArn()));
            }
            case "LastRunStatus": {
                return Optional.ofNullable(clazz.cast(this.lastRunStatus()));
            }
            case "LastRunFailureReason": {
                return Optional.ofNullable(clazz.cast(this.lastRunFailureReason()));
            }
            case "LastReportGenerationTime": {
                return Optional.ofNullable(clazz.cast(this.lastReportGenerationTime()));
            }
            case "ReportCreatorAccount": {
                return Optional.ofNullable(clazz.cast(this.reportCreatorAccount()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "S3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportGenerator, T> g) {
        return obj -> g.apply((ReportGenerator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportGeneratorName;
        private List<String> reportType = DefaultSdkAutoConstructList.getInstance();
        private ReportContext reportContext;
        private ReportFrequency reportFrequency;
        private String licenseManagerReportGeneratorArn;
        private String lastRunStatus;
        private String lastRunFailureReason;
        private String lastReportGenerationTime;
        private String reportCreatorAccount;
        private String description;
        private S3Location s3Location;
        private String createTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportGenerator model) {
            this.reportGeneratorName(model.reportGeneratorName);
            this.reportTypeWithStrings(model.reportType);
            this.reportContext(model.reportContext);
            this.reportFrequency(model.reportFrequency);
            this.licenseManagerReportGeneratorArn(model.licenseManagerReportGeneratorArn);
            this.lastRunStatus(model.lastRunStatus);
            this.lastRunFailureReason(model.lastRunFailureReason);
            this.lastReportGenerationTime(model.lastReportGenerationTime);
            this.reportCreatorAccount(model.reportCreatorAccount);
            this.description(model.description);
            this.s3Location(model.s3Location);
            this.createTime(model.createTime);
            this.tags(model.tags);
        }

        public final String getReportGeneratorName() {
            return this.reportGeneratorName;
        }

        @Override
        public final Builder reportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
            return this;
        }

        public final void setReportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
        }

        public final Collection<String> getReportType() {
            if (this.reportType instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportType;
        }

        @Override
        public final Builder reportTypeWithStrings(Collection<String> reportType) {
            this.reportType = ReportTypeListCopier.copy(reportType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportTypeWithStrings(String ... reportType) {
            this.reportTypeWithStrings(Arrays.asList(reportType));
            return this;
        }

        @Override
        public final Builder reportType(Collection<ReportType> reportType) {
            this.reportType = ReportTypeListCopier.copyEnumToString(reportType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportType(ReportType ... reportType) {
            this.reportType(Arrays.asList(reportType));
            return this;
        }

        public final void setReportType(Collection<String> reportType) {
            this.reportType = ReportTypeListCopier.copy(reportType);
        }

        public final ReportContext.Builder getReportContext() {
            return this.reportContext != null ? this.reportContext.toBuilder() : null;
        }

        @Override
        public final Builder reportContext(ReportContext reportContext) {
            this.reportContext = reportContext;
            return this;
        }

        public final void setReportContext(ReportContext.BuilderImpl reportContext) {
            this.reportContext = reportContext != null ? reportContext.build() : null;
        }

        public final ReportFrequency.Builder getReportFrequency() {
            return this.reportFrequency != null ? this.reportFrequency.toBuilder() : null;
        }

        @Override
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        public final void setReportFrequency(ReportFrequency.BuilderImpl reportFrequency) {
            this.reportFrequency = reportFrequency != null ? reportFrequency.build() : null;
        }

        public final String getLicenseManagerReportGeneratorArn() {
            return this.licenseManagerReportGeneratorArn;
        }

        @Override
        public final Builder licenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
            this.licenseManagerReportGeneratorArn = licenseManagerReportGeneratorArn;
            return this;
        }

        public final void setLicenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
            this.licenseManagerReportGeneratorArn = licenseManagerReportGeneratorArn;
        }

        public final String getLastRunStatus() {
            return this.lastRunStatus;
        }

        @Override
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        public final String getLastRunFailureReason() {
            return this.lastRunFailureReason;
        }

        @Override
        public final Builder lastRunFailureReason(String lastRunFailureReason) {
            this.lastRunFailureReason = lastRunFailureReason;
            return this;
        }

        public final void setLastRunFailureReason(String lastRunFailureReason) {
            this.lastRunFailureReason = lastRunFailureReason;
        }

        public final String getLastReportGenerationTime() {
            return this.lastReportGenerationTime;
        }

        @Override
        public final Builder lastReportGenerationTime(String lastReportGenerationTime) {
            this.lastReportGenerationTime = lastReportGenerationTime;
            return this;
        }

        public final void setLastReportGenerationTime(String lastReportGenerationTime) {
            this.lastReportGenerationTime = lastReportGenerationTime;
        }

        public final String getReportCreatorAccount() {
            return this.reportCreatorAccount;
        }

        @Override
        public final Builder reportCreatorAccount(String reportCreatorAccount) {
            this.reportCreatorAccount = reportCreatorAccount;
            return this;
        }

        public final void setReportCreatorAccount(String reportCreatorAccount) {
            this.reportCreatorAccount = reportCreatorAccount;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final S3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public final String getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ReportGenerator build() {
            return new ReportGenerator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportGenerator> {
        public Builder reportGeneratorName(String var1);

        public Builder reportTypeWithStrings(Collection<String> var1);

        public Builder reportTypeWithStrings(String ... var1);

        public Builder reportType(Collection<ReportType> var1);

        public Builder reportType(ReportType ... var1);

        public Builder reportContext(ReportContext var1);

        default public Builder reportContext(Consumer<ReportContext.Builder> reportContext) {
            return this.reportContext((ReportContext)((ReportContext.Builder)ReportContext.builder().applyMutation(reportContext)).build());
        }

        public Builder reportFrequency(ReportFrequency var1);

        default public Builder reportFrequency(Consumer<ReportFrequency.Builder> reportFrequency) {
            return this.reportFrequency((ReportFrequency)((ReportFrequency.Builder)ReportFrequency.builder().applyMutation(reportFrequency)).build());
        }

        public Builder licenseManagerReportGeneratorArn(String var1);

        public Builder lastRunStatus(String var1);

        public Builder lastRunFailureReason(String var1);

        public Builder lastReportGenerationTime(String var1);

        public Builder reportCreatorAccount(String var1);

        public Builder description(String var1);

        public Builder s3Location(S3Location var1);

        default public Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return this.s3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3Location)).build());
        }

        public Builder createTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

