/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.Metadata;
import software.amazon.awssdk.services.licensemanager.model.MetadataListCopier;
import software.amazon.awssdk.services.licensemanager.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseOperationFailure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseOperationFailure> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(LicenseOperationFailure.getter(LicenseOperationFailure::resourceArn)).setter(LicenseOperationFailure.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(LicenseOperationFailure.getter(LicenseOperationFailure::resourceTypeAsString)).setter(LicenseOperationFailure.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(LicenseOperationFailure.getter(LicenseOperationFailure::errorMessage)).setter(LicenseOperationFailure.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> FAILURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FailureTime").getter(LicenseOperationFailure.getter(LicenseOperationFailure::failureTime)).setter(LicenseOperationFailure.setter(Builder::failureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureTime").build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(LicenseOperationFailure.getter(LicenseOperationFailure::operationName)).setter(LicenseOperationFailure.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(LicenseOperationFailure.getter(LicenseOperationFailure::resourceOwnerId)).setter(LicenseOperationFailure.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").build()}).build();
    private static final SdkField<String> OPERATION_REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationRequestedBy").getter(LicenseOperationFailure.getter(LicenseOperationFailure::operationRequestedBy)).setter(LicenseOperationFailure.setter(Builder::operationRequestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationRequestedBy").build()}).build();
    private static final SdkField<List<Metadata>> METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetadataList").getter(LicenseOperationFailure.getter(LicenseOperationFailure::metadataList)).setter(LicenseOperationFailure.setter(Builder::metadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, ERROR_MESSAGE_FIELD, FAILURE_TIME_FIELD, OPERATION_NAME_FIELD, RESOURCE_OWNER_ID_FIELD, OPERATION_REQUESTED_BY_FIELD, METADATA_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String resourceType;
    private final String errorMessage;
    private final Instant failureTime;
    private final String operationName;
    private final String resourceOwnerId;
    private final String operationRequestedBy;
    private final List<Metadata> metadataList;

    private LicenseOperationFailure(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.errorMessage = builder.errorMessage;
        this.failureTime = builder.failureTime;
        this.operationName = builder.operationName;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.operationRequestedBy = builder.operationRequestedBy;
        this.metadataList = builder.metadataList;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant failureTime() {
        return this.failureTime;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public final String operationRequestedBy() {
        return this.operationRequestedBy;
    }

    public final boolean hasMetadataList() {
        return this.metadataList != null && !(this.metadataList instanceof SdkAutoConstructList);
    }

    public final List<Metadata> metadataList() {
        return this.metadataList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationRequestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataList() ? this.metadataList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseOperationFailure)) {
            return false;
        }
        LicenseOperationFailure other = (LicenseOperationFailure)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.failureTime(), other.failureTime()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.operationRequestedBy(), other.operationRequestedBy()) && this.hasMetadataList() == other.hasMetadataList() && Objects.equals(this.metadataList(), other.metadataList());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseOperationFailure").add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("FailureTime", (Object)this.failureTime()).add("OperationName", (Object)this.operationName()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("OperationRequestedBy", (Object)this.operationRequestedBy()).add("MetadataList", this.hasMetadataList() ? this.metadataList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "FailureTime": {
                return Optional.ofNullable(clazz.cast(this.failureTime()));
            }
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "OperationRequestedBy": {
                return Optional.ofNullable(clazz.cast(this.operationRequestedBy()));
            }
            case "MetadataList": {
                return Optional.ofNullable(clazz.cast(this.metadataList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseOperationFailure, T> g) {
        return obj -> g.apply((LicenseOperationFailure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourceType;
        private String errorMessage;
        private Instant failureTime;
        private String operationName;
        private String resourceOwnerId;
        private String operationRequestedBy;
        private List<Metadata> metadataList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseOperationFailure model) {
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.errorMessage(model.errorMessage);
            this.failureTime(model.failureTime);
            this.operationName(model.operationName);
            this.resourceOwnerId(model.resourceOwnerId);
            this.operationRequestedBy(model.operationRequestedBy);
            this.metadataList(model.metadataList);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getFailureTime() {
            return this.failureTime;
        }

        @Override
        public final Builder failureTime(Instant failureTime) {
            this.failureTime = failureTime;
            return this;
        }

        public final void setFailureTime(Instant failureTime) {
            this.failureTime = failureTime;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        public final String getOperationRequestedBy() {
            return this.operationRequestedBy;
        }

        @Override
        public final Builder operationRequestedBy(String operationRequestedBy) {
            this.operationRequestedBy = operationRequestedBy;
            return this;
        }

        public final void setOperationRequestedBy(String operationRequestedBy) {
            this.operationRequestedBy = operationRequestedBy;
        }

        public final List<Metadata.Builder> getMetadataList() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.metadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metadataList(Collection<Metadata> metadataList) {
            this.metadataList = MetadataListCopier.copy(metadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataList(Metadata ... metadataList) {
            this.metadataList(Arrays.asList(metadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataList(Consumer<Metadata.Builder> ... metadataList) {
            this.metadataList(Stream.of(metadataList).map(c -> (Metadata)((Metadata.Builder)Metadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetadataList(Collection<Metadata.BuilderImpl> metadataList) {
            this.metadataList = MetadataListCopier.copyFromBuilder(metadataList);
        }

        public LicenseOperationFailure build() {
            return new LicenseOperationFailure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseOperationFailure> {
        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder errorMessage(String var1);

        public Builder failureTime(Instant var1);

        public Builder operationName(String var1);

        public Builder resourceOwnerId(String var1);

        public Builder operationRequestedBy(String var1);

        public Builder metadataList(Collection<Metadata> var1);

        public Builder metadataList(Metadata ... var1);

        public Builder metadataList(Consumer<Metadata.Builder> ... var1);
    }
}

