/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum GrantStatus {
    PENDING_WORKFLOW("PENDING_WORKFLOW"),
    PENDING_ACCEPT("PENDING_ACCEPT"),
    REJECTED("REJECTED"),
    ACTIVE("ACTIVE"),
    FAILED_WORKFLOW("FAILED_WORKFLOW"),
    DELETED("DELETED"),
    PENDING_DELETE("PENDING_DELETE"),
    DISABLED("DISABLED"),
    WORKFLOW_COMPLETED("WORKFLOW_COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private GrantStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GrantStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(GrantStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GrantStatus> knownValues() {
        return Stream.of(GrantStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

