/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration;
import software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration;
import software.amazon.awssdk.services.licensemanager.model.RenewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsumptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsumptionConfiguration> {
    private static final SdkField<String> RENEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewType").getter(ConsumptionConfiguration.getter(ConsumptionConfiguration::renewTypeAsString)).setter(ConsumptionConfiguration.setter(Builder::renewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewType").build()}).build();
    private static final SdkField<ProvisionalConfiguration> PROVISIONAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionalConfiguration").getter(ConsumptionConfiguration.getter(ConsumptionConfiguration::provisionalConfiguration)).setter(ConsumptionConfiguration.setter(Builder::provisionalConfiguration)).constructor(ProvisionalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionalConfiguration").build()}).build();
    private static final SdkField<BorrowConfiguration> BORROW_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BorrowConfiguration").getter(ConsumptionConfiguration.getter(ConsumptionConfiguration::borrowConfiguration)).setter(ConsumptionConfiguration.setter(Builder::borrowConfiguration)).constructor(BorrowConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEW_TYPE_FIELD, PROVISIONAL_CONFIGURATION_FIELD, BORROW_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String renewType;
    private final ProvisionalConfiguration provisionalConfiguration;
    private final BorrowConfiguration borrowConfiguration;

    private ConsumptionConfiguration(BuilderImpl builder) {
        this.renewType = builder.renewType;
        this.provisionalConfiguration = builder.provisionalConfiguration;
        this.borrowConfiguration = builder.borrowConfiguration;
    }

    public final RenewType renewType() {
        return RenewType.fromValue(this.renewType);
    }

    public final String renewTypeAsString() {
        return this.renewType;
    }

    public final ProvisionalConfiguration provisionalConfiguration() {
        return this.provisionalConfiguration;
    }

    public final BorrowConfiguration borrowConfiguration() {
        return this.borrowConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.borrowConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumptionConfiguration)) {
            return false;
        }
        ConsumptionConfiguration other = (ConsumptionConfiguration)obj;
        return Objects.equals(this.renewTypeAsString(), other.renewTypeAsString()) && Objects.equals(this.provisionalConfiguration(), other.provisionalConfiguration()) && Objects.equals(this.borrowConfiguration(), other.borrowConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ConsumptionConfiguration").add("RenewType", (Object)this.renewTypeAsString()).add("ProvisionalConfiguration", (Object)this.provisionalConfiguration()).add("BorrowConfiguration", (Object)this.borrowConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenewType": {
                return Optional.ofNullable(clazz.cast(this.renewTypeAsString()));
            }
            case "ProvisionalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.provisionalConfiguration()));
            }
            case "BorrowConfiguration": {
                return Optional.ofNullable(clazz.cast(this.borrowConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConsumptionConfiguration, T> g) {
        return obj -> g.apply((ConsumptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String renewType;
        private ProvisionalConfiguration provisionalConfiguration;
        private BorrowConfiguration borrowConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumptionConfiguration model) {
            this.renewType(model.renewType);
            this.provisionalConfiguration(model.provisionalConfiguration);
            this.borrowConfiguration(model.borrowConfiguration);
        }

        public final String getRenewType() {
            return this.renewType;
        }

        @Override
        public final Builder renewType(String renewType) {
            this.renewType = renewType;
            return this;
        }

        @Override
        public final Builder renewType(RenewType renewType) {
            this.renewType(renewType == null ? null : renewType.toString());
            return this;
        }

        public final void setRenewType(String renewType) {
            this.renewType = renewType;
        }

        public final ProvisionalConfiguration.Builder getProvisionalConfiguration() {
            return this.provisionalConfiguration != null ? this.provisionalConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder provisionalConfiguration(ProvisionalConfiguration provisionalConfiguration) {
            this.provisionalConfiguration = provisionalConfiguration;
            return this;
        }

        public final void setProvisionalConfiguration(ProvisionalConfiguration.BuilderImpl provisionalConfiguration) {
            this.provisionalConfiguration = provisionalConfiguration != null ? provisionalConfiguration.build() : null;
        }

        public final BorrowConfiguration.Builder getBorrowConfiguration() {
            return this.borrowConfiguration != null ? this.borrowConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder borrowConfiguration(BorrowConfiguration borrowConfiguration) {
            this.borrowConfiguration = borrowConfiguration;
            return this;
        }

        public final void setBorrowConfiguration(BorrowConfiguration.BuilderImpl borrowConfiguration) {
            this.borrowConfiguration = borrowConfiguration != null ? borrowConfiguration.build() : null;
        }

        public ConsumptionConfiguration build() {
            return new ConsumptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsumptionConfiguration> {
        public Builder renewType(String var1);

        public Builder renewType(RenewType var1);

        public Builder provisionalConfiguration(ProvisionalConfiguration var1);

        default public Builder provisionalConfiguration(Consumer<ProvisionalConfiguration.Builder> provisionalConfiguration) {
            return this.provisionalConfiguration((ProvisionalConfiguration)((ProvisionalConfiguration.Builder)ProvisionalConfiguration.builder().applyMutation(provisionalConfiguration)).build());
        }

        public Builder borrowConfiguration(BorrowConfiguration var1);

        default public Builder borrowConfiguration(Consumer<BorrowConfiguration.Builder> borrowConfiguration) {
            return this.borrowConfiguration((BorrowConfiguration)((BorrowConfiguration.Builder)BorrowConfiguration.builder().applyMutation(borrowConfiguration)).build());
        }
    }
}

