/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RenewType {
    NONE("None"),
    WEEKLY("Weekly"),
    MONTHLY("Monthly"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RenewType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RenewType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RenewType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RenewType> knownValues() {
        return Stream.of(RenewType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

