/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration;
import software.amazon.awssdk.services.licensemanager.model.DatetimeRange;
import software.amazon.awssdk.services.licensemanager.model.Entitlement;
import software.amazon.awssdk.services.licensemanager.model.EntitlementListCopier;
import software.amazon.awssdk.services.licensemanager.model.Issuer;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.Metadata;
import software.amazon.awssdk.services.licensemanager.model.MetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateLicenseRequest> {
    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseName").getter(CreateLicenseRequest.getter(CreateLicenseRequest::licenseName)).setter(CreateLicenseRequest.setter(Builder::licenseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseName").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(CreateLicenseRequest.getter(CreateLicenseRequest::productName)).setter(CreateLicenseRequest.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> PRODUCT_SKU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductSKU").getter(CreateLicenseRequest.getter(CreateLicenseRequest::productSKU)).setter(CreateLicenseRequest.setter(Builder::productSKU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSKU").build()}).build();
    private static final SdkField<Issuer> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Issuer").getter(CreateLicenseRequest.getter(CreateLicenseRequest::issuer)).setter(CreateLicenseRequest.setter(Builder::issuer)).constructor(Issuer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(CreateLicenseRequest.getter(CreateLicenseRequest::homeRegion)).setter(CreateLicenseRequest.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<DatetimeRange> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Validity").getter(CreateLicenseRequest.getter(CreateLicenseRequest::validity)).setter(CreateLicenseRequest.setter(Builder::validity)).constructor(DatetimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()}).build();
    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(CreateLicenseRequest.getter(CreateLicenseRequest::entitlements)).setter(CreateLicenseRequest.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entitlement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Beneficiary").getter(CreateLicenseRequest.getter(CreateLicenseRequest::beneficiary)).setter(CreateLicenseRequest.setter(Builder::beneficiary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()}).build();
    private static final SdkField<ConsumptionConfiguration> CONSUMPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumptionConfiguration").getter(CreateLicenseRequest.getter(CreateLicenseRequest::consumptionConfiguration)).setter(CreateLicenseRequest.setter(Builder::consumptionConfiguration)).constructor(ConsumptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumptionConfiguration").build()}).build();
    private static final SdkField<List<Metadata>> LICENSE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseMetadata").getter(CreateLicenseRequest.getter(CreateLicenseRequest::licenseMetadata)).setter(CreateLicenseRequest.setter(Builder::licenseMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateLicenseRequest.getter(CreateLicenseRequest::clientToken)).setter(CreateLicenseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_NAME_FIELD, PRODUCT_NAME_FIELD, PRODUCT_SKU_FIELD, ISSUER_FIELD, HOME_REGION_FIELD, VALIDITY_FIELD, ENTITLEMENTS_FIELD, BENEFICIARY_FIELD, CONSUMPTION_CONFIGURATION_FIELD, LICENSE_METADATA_FIELD, CLIENT_TOKEN_FIELD));
    private final String licenseName;
    private final String productName;
    private final String productSKU;
    private final Issuer issuer;
    private final String homeRegion;
    private final DatetimeRange validity;
    private final List<Entitlement> entitlements;
    private final String beneficiary;
    private final ConsumptionConfiguration consumptionConfiguration;
    private final List<Metadata> licenseMetadata;
    private final String clientToken;

    private CreateLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.licenseName = builder.licenseName;
        this.productName = builder.productName;
        this.productSKU = builder.productSKU;
        this.issuer = builder.issuer;
        this.homeRegion = builder.homeRegion;
        this.validity = builder.validity;
        this.entitlements = builder.entitlements;
        this.beneficiary = builder.beneficiary;
        this.consumptionConfiguration = builder.consumptionConfiguration;
        this.licenseMetadata = builder.licenseMetadata;
        this.clientToken = builder.clientToken;
    }

    public final String licenseName() {
        return this.licenseName;
    }

    public final String productName() {
        return this.productName;
    }

    public final String productSKU() {
        return this.productSKU;
    }

    public final Issuer issuer() {
        return this.issuer;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final DatetimeRange validity() {
        return this.validity;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<Entitlement> entitlements() {
        return this.entitlements;
    }

    public final String beneficiary() {
        return this.beneficiary;
    }

    public final ConsumptionConfiguration consumptionConfiguration() {
        return this.consumptionConfiguration;
    }

    public final boolean hasLicenseMetadata() {
        return this.licenseMetadata != null && !(this.licenseMetadata instanceof SdkAutoConstructList);
    }

    public final List<Metadata> licenseMetadata() {
        return this.licenseMetadata;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productSKU());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.beneficiary());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseMetadata() ? this.licenseMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseRequest)) {
            return false;
        }
        CreateLicenseRequest other = (CreateLicenseRequest)((Object)obj);
        return Objects.equals(this.licenseName(), other.licenseName()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.productSKU(), other.productSKU()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.validity(), other.validity()) && this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.beneficiary(), other.beneficiary()) && Objects.equals(this.consumptionConfiguration(), other.consumptionConfiguration()) && this.hasLicenseMetadata() == other.hasLicenseMetadata() && Objects.equals(this.licenseMetadata(), other.licenseMetadata()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseRequest").add("LicenseName", (Object)this.licenseName()).add("ProductName", (Object)this.productName()).add("ProductSKU", (Object)this.productSKU()).add("Issuer", (Object)this.issuer()).add("HomeRegion", (Object)this.homeRegion()).add("Validity", (Object)this.validity()).add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("Beneficiary", (Object)this.beneficiary()).add("ConsumptionConfiguration", (Object)this.consumptionConfiguration()).add("LicenseMetadata", this.hasLicenseMetadata() ? this.licenseMetadata() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseName": {
                return Optional.ofNullable(clazz.cast(this.licenseName()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "ProductSKU": {
                return Optional.ofNullable(clazz.cast(this.productSKU()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "Validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "Beneficiary": {
                return Optional.ofNullable(clazz.cast(this.beneficiary()));
            }
            case "ConsumptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.consumptionConfiguration()));
            }
            case "LicenseMetadata": {
                return Optional.ofNullable(clazz.cast(this.licenseMetadata()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseRequest, T> g) {
        return obj -> g.apply((CreateLicenseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseName;
        private String productName;
        private String productSKU;
        private Issuer issuer;
        private String homeRegion;
        private DatetimeRange validity;
        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();
        private String beneficiary;
        private ConsumptionConfiguration consumptionConfiguration;
        private List<Metadata> licenseMetadata = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseRequest model) {
            super(model);
            this.licenseName(model.licenseName);
            this.productName(model.productName);
            this.productSKU(model.productSKU);
            this.issuer(model.issuer);
            this.homeRegion(model.homeRegion);
            this.validity(model.validity);
            this.entitlements(model.entitlements);
            this.beneficiary(model.beneficiary);
            this.consumptionConfiguration(model.consumptionConfiguration);
            this.licenseMetadata(model.licenseMetadata);
            this.clientToken(model.clientToken);
        }

        public final String getLicenseName() {
            return this.licenseName;
        }

        @Override
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        public final String getProductName() {
            return this.productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        public final String getProductSKU() {
            return this.productSKU;
        }

        @Override
        public final Builder productSKU(String productSKU) {
            this.productSKU = productSKU;
            return this;
        }

        public final void setProductSKU(String productSKU) {
            this.productSKU = productSKU;
        }

        public final Issuer.Builder getIssuer() {
            return this.issuer != null ? this.issuer.toBuilder() : null;
        }

        @Override
        public final Builder issuer(Issuer issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(Issuer.BuilderImpl issuer) {
            this.issuer = issuer != null ? issuer.build() : null;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        public final DatetimeRange.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(DatetimeRange validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(DatetimeRange.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public final Collection<Entitlement.Builder> getEntitlements() {
            if (this.entitlements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entitlements != null ? (Collection)this.entitlements.stream().map(Entitlement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = EntitlementListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (Entitlement)((Entitlement.Builder)Entitlement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = EntitlementListCopier.copyFromBuilder(entitlements);
        }

        public final String getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        public final ConsumptionConfiguration.Builder getConsumptionConfiguration() {
            return this.consumptionConfiguration != null ? this.consumptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        public final void setConsumptionConfiguration(ConsumptionConfiguration.BuilderImpl consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration != null ? consumptionConfiguration.build() : null;
        }

        public final Collection<Metadata.Builder> getLicenseMetadata() {
            if (this.licenseMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseMetadata != null ? (Collection)this.licenseMetadata.stream().map(Metadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseMetadata(Collection<Metadata> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copy(licenseMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Metadata ... licenseMetadata) {
            this.licenseMetadata(Arrays.asList(licenseMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Consumer<Metadata.Builder> ... licenseMetadata) {
            this.licenseMetadata(Stream.of(licenseMetadata).map(c -> (Metadata)((Metadata.Builder)Metadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseMetadata(Collection<Metadata.BuilderImpl> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copyFromBuilder(licenseMetadata);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseRequest build() {
            return new CreateLicenseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseRequest> {
        public Builder licenseName(String var1);

        public Builder productName(String var1);

        public Builder productSKU(String var1);

        public Builder issuer(Issuer var1);

        default public Builder issuer(Consumer<Issuer.Builder> issuer) {
            return this.issuer((Issuer)((Issuer.Builder)Issuer.builder().applyMutation(issuer)).build());
        }

        public Builder homeRegion(String var1);

        public Builder validity(DatetimeRange var1);

        default public Builder validity(Consumer<DatetimeRange.Builder> validity) {
            return this.validity((DatetimeRange)((DatetimeRange.Builder)DatetimeRange.builder().applyMutation(validity)).build());
        }

        public Builder entitlements(Collection<Entitlement> var1);

        public Builder entitlements(Entitlement ... var1);

        public Builder entitlements(Consumer<Entitlement.Builder> ... var1);

        public Builder beneficiary(String var1);

        public Builder consumptionConfiguration(ConsumptionConfiguration var1);

        default public Builder consumptionConfiguration(Consumer<ConsumptionConfiguration.Builder> consumptionConfiguration) {
            return this.consumptionConfiguration((ConsumptionConfiguration)((ConsumptionConfiguration.Builder)ConsumptionConfiguration.builder().applyMutation(consumptionConfiguration)).build());
        }

        public Builder licenseMetadata(Collection<Metadata> var1);

        public Builder licenseMetadata(Metadata ... var1);

        public Builder licenseMetadata(Consumer<Metadata.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

