/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.EntitlementUsage;
import software.amazon.awssdk.services.licensemanager.model.EntitlementUsageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseUsage> {
    private static final SdkField<List<EntitlementUsage>> ENTITLEMENT_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntitlementUsages").getter(LicenseUsage.getter(LicenseUsage::entitlementUsages)).setter(LicenseUsage.setter(Builder::entitlementUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitlementUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENT_USAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<EntitlementUsage> entitlementUsages;

    private LicenseUsage(BuilderImpl builder) {
        this.entitlementUsages = builder.entitlementUsages;
    }

    public boolean hasEntitlementUsages() {
        return this.entitlementUsages != null && !(this.entitlementUsages instanceof SdkAutoConstructList);
    }

    public List<EntitlementUsage> entitlementUsages() {
        return this.entitlementUsages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlementUsages() ? this.entitlementUsages() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseUsage)) {
            return false;
        }
        LicenseUsage other = (LicenseUsage)obj;
        return this.hasEntitlementUsages() == other.hasEntitlementUsages() && Objects.equals(this.entitlementUsages(), other.entitlementUsages());
    }

    public String toString() {
        return ToString.builder((String)"LicenseUsage").add("EntitlementUsages", this.hasEntitlementUsages() ? this.entitlementUsages() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntitlementUsages": {
                return Optional.ofNullable(clazz.cast(this.entitlementUsages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseUsage, T> g) {
        return obj -> g.apply((LicenseUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EntitlementUsage> entitlementUsages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseUsage model) {
            this.entitlementUsages(model.entitlementUsages);
        }

        public final Collection<EntitlementUsage.Builder> getEntitlementUsages() {
            if (this.entitlementUsages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entitlementUsages != null ? (Collection)this.entitlementUsages.stream().map(EntitlementUsage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlementUsages(Collection<EntitlementUsage> entitlementUsages) {
            this.entitlementUsages = EntitlementUsageListCopier.copy(entitlementUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementUsages(EntitlementUsage ... entitlementUsages) {
            this.entitlementUsages(Arrays.asList(entitlementUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementUsages(Consumer<EntitlementUsage.Builder> ... entitlementUsages) {
            this.entitlementUsages(Stream.of(entitlementUsages).map(c -> (EntitlementUsage)((EntitlementUsage.Builder)EntitlementUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlementUsages(Collection<EntitlementUsage.BuilderImpl> entitlementUsages) {
            this.entitlementUsages = EntitlementUsageListCopier.copyFromBuilder(entitlementUsages);
        }

        public LicenseUsage build() {
            return new LicenseUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseUsage> {
        public Builder entitlementUsages(Collection<EntitlementUsage> var1);

        public Builder entitlementUsages(EntitlementUsage ... var1);

        public Builder entitlementUsages(Consumer<EntitlementUsage.Builder> ... var1);
    }
}

