/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Issuer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Issuer> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Issuer.getter(Issuer::name)).setter(Issuer.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SIGN_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignKey").getter(Issuer.getter(Issuer::signKey)).setter(Issuer.setter(Builder::signKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SIGN_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String signKey;

    private Issuer(BuilderImpl builder) {
        this.name = builder.name;
        this.signKey = builder.signKey;
    }

    public String name() {
        return this.name;
    }

    public String signKey() {
        return this.signKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.signKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Issuer)) {
            return false;
        }
        Issuer other = (Issuer)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.signKey(), other.signKey());
    }

    public String toString() {
        return ToString.builder((String)"Issuer").add("Name", (Object)this.name()).add("SignKey", (Object)this.signKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SignKey": {
                return Optional.ofNullable(clazz.cast(this.signKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Issuer, T> g) {
        return obj -> g.apply((Issuer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String signKey;

        private BuilderImpl() {
        }

        private BuilderImpl(Issuer model) {
            this.name(model.name);
            this.signKey(model.signKey);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSignKey() {
            return this.signKey;
        }

        @Override
        public final Builder signKey(String signKey) {
            this.signKey = signKey;
            return this;
        }

        public final void setSignKey(String signKey) {
            this.signKey = signKey;
        }

        public Issuer build() {
            return new Issuer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Issuer> {
        public Builder name(String var1);

        public Builder signKey(String var1);
    }
}

