/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseConfiguration;
import software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationsCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLicenseConfigurationsResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListLicenseConfigurationsResponse> {
    private static final SdkField<List<LicenseConfiguration>> LICENSE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseConfigurations").getter(ListLicenseConfigurationsResponse.getter(ListLicenseConfigurationsResponse::licenseConfigurations)).setter(ListLicenseConfigurationsResponse.setter(Builder::licenseConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLicenseConfigurationsResponse.getter(ListLicenseConfigurationsResponse::nextToken)).setter(ListLicenseConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LicenseConfiguration> licenseConfigurations;
    private final String nextToken;

    private ListLicenseConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurations = builder.licenseConfigurations;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLicenseConfigurations() {
        return this.licenseConfigurations != null && !(this.licenseConfigurations instanceof SdkAutoConstructList);
    }

    public List<LicenseConfiguration> licenseConfigurations() {
        return this.licenseConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseConfigurations() ? this.licenseConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseConfigurationsResponse)) {
            return false;
        }
        ListLicenseConfigurationsResponse other = (ListLicenseConfigurationsResponse)((Object)obj);
        return this.hasLicenseConfigurations() == other.hasLicenseConfigurations() && Objects.equals(this.licenseConfigurations(), other.licenseConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLicenseConfigurationsResponse").add("LicenseConfigurations", this.hasLicenseConfigurations() ? this.licenseConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConfigurations": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseConfigurationsResponse, T> g) {
        return obj -> g.apply((ListLicenseConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseConfiguration> licenseConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseConfigurationsResponse model) {
            super(model);
            this.licenseConfigurations(model.licenseConfigurations);
            this.nextToken(model.nextToken);
        }

        public final Collection<LicenseConfiguration.Builder> getLicenseConfigurations() {
            if (this.licenseConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseConfigurations != null ? (Collection)this.licenseConfigurations.stream().map(LicenseConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseConfigurations(Collection<LicenseConfiguration> licenseConfigurations) {
            this.licenseConfigurations = LicenseConfigurationsCopier.copy(licenseConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurations(LicenseConfiguration ... licenseConfigurations) {
            this.licenseConfigurations(Arrays.asList(licenseConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurations(Consumer<LicenseConfiguration.Builder> ... licenseConfigurations) {
            this.licenseConfigurations(Stream.of(licenseConfigurations).map(c -> (LicenseConfiguration)((LicenseConfiguration.Builder)LicenseConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseConfigurations(Collection<LicenseConfiguration.BuilderImpl> licenseConfigurations) {
            this.licenseConfigurations = LicenseConfigurationsCopier.copyFromBuilder(licenseConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLicenseConfigurationsResponse build() {
            return new ListLicenseConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLicenseConfigurationsResponse> {
        public Builder licenseConfigurations(Collection<LicenseConfiguration> var1);

        public Builder licenseConfigurations(LicenseConfiguration ... var1);

        public Builder licenseConfigurations(Consumer<LicenseConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

