/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseCountingType;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.ProductInformation;
import software.amazon.awssdk.services.licensemanager.model.ProductInformationListCopier;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.services.licensemanager.model.Tag;
import software.amazon.awssdk.services.licensemanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseConfigurationRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CreateLicenseConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::name)).setter(CreateLicenseConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::description)).setter(CreateLicenseConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LICENSE_COUNTING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseCountingType").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::licenseCountingTypeAsString)).setter(CreateLicenseConfigurationRequest.setter(Builder::licenseCountingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountingType").build()}).build();
    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LicenseCount").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::licenseCount)).setter(CreateLicenseConfigurationRequest.setter(Builder::licenseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()}).build();
    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LicenseCountHardLimit").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::licenseCountHardLimit)).setter(CreateLicenseConfigurationRequest.setter(Builder::licenseCountHardLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build()}).build();
    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseRules").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::licenseRules)).setter(CreateLicenseConfigurationRequest.setter(Builder::licenseRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::tags)).setter(CreateLicenseConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProductInformation>> PRODUCT_INFORMATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductInformationList").getter(CreateLicenseConfigurationRequest.getter(CreateLicenseConfigurationRequest::productInformationList)).setter(CreateLicenseConfigurationRequest.setter(Builder::productInformationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, LICENSE_COUNTING_TYPE_FIELD, LICENSE_COUNT_FIELD, LICENSE_COUNT_HARD_LIMIT_FIELD, LICENSE_RULES_FIELD, TAGS_FIELD, PRODUCT_INFORMATION_LIST_FIELD));
    private final String name;
    private final String description;
    private final String licenseCountingType;
    private final Long licenseCount;
    private final Boolean licenseCountHardLimit;
    private final List<String> licenseRules;
    private final List<Tag> tags;
    private final List<ProductInformation> productInformationList;

    private CreateLicenseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.licenseCountingType = builder.licenseCountingType;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.licenseRules = builder.licenseRules;
        this.tags = builder.tags;
        this.productInformationList = builder.productInformationList;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public LicenseCountingType licenseCountingType() {
        return LicenseCountingType.fromValue(this.licenseCountingType);
    }

    public String licenseCountingTypeAsString() {
        return this.licenseCountingType;
    }

    public Long licenseCount() {
        return this.licenseCount;
    }

    public Boolean licenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public boolean hasLicenseRules() {
        return this.licenseRules != null && !(this.licenseRules instanceof SdkAutoConstructList);
    }

    public List<String> licenseRules() {
        return this.licenseRules;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public boolean hasProductInformationList() {
        return this.productInformationList != null && !(this.productInformationList instanceof SdkAutoConstructList);
    }

    public List<ProductInformation> productInformationList() {
        return this.productInformationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCountingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.productInformationList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseConfigurationRequest)) {
            return false;
        }
        CreateLicenseConfigurationRequest other = (CreateLicenseConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.licenseCountingTypeAsString(), other.licenseCountingTypeAsString()) && Objects.equals(this.licenseCount(), other.licenseCount()) && Objects.equals(this.licenseCountHardLimit(), other.licenseCountHardLimit()) && Objects.equals(this.licenseRules(), other.licenseRules()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.productInformationList(), other.productInformationList());
    }

    public String toString() {
        return ToString.builder((String)"CreateLicenseConfigurationRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LicenseCountingType", (Object)this.licenseCountingTypeAsString()).add("LicenseCount", (Object)this.licenseCount()).add("LicenseCountHardLimit", (Object)this.licenseCountHardLimit()).add("LicenseRules", this.licenseRules()).add("Tags", this.tags()).add("ProductInformationList", this.productInformationList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LicenseCountingType": {
                return Optional.ofNullable(clazz.cast(this.licenseCountingTypeAsString()));
            }
            case "LicenseCount": {
                return Optional.ofNullable(clazz.cast(this.licenseCount()));
            }
            case "LicenseCountHardLimit": {
                return Optional.ofNullable(clazz.cast(this.licenseCountHardLimit()));
            }
            case "LicenseRules": {
                return Optional.ofNullable(clazz.cast(this.licenseRules()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ProductInformationList": {
                return Optional.ofNullable(clazz.cast(this.productInformationList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseConfigurationRequest, T> g) {
        return obj -> g.apply((CreateLicenseConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String licenseCountingType;
        private Long licenseCount;
        private Boolean licenseCountHardLimit;
        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<ProductInformation> productInformationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseConfigurationRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.licenseCountingType(model.licenseCountingType);
            this.licenseCount(model.licenseCount);
            this.licenseCountHardLimit(model.licenseCountHardLimit);
            this.licenseRules(model.licenseRules);
            this.tags(model.tags);
            this.productInformationList(model.productInformationList);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLicenseCountingType() {
            return this.licenseCountingType;
        }

        @Override
        public final Builder licenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
            return this;
        }

        @Override
        public final Builder licenseCountingType(LicenseCountingType licenseCountingType) {
            this.licenseCountingType(licenseCountingType == null ? null : licenseCountingType.toString());
            return this;
        }

        public final void setLicenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
        }

        public final Long getLicenseCount() {
            return this.licenseCount;
        }

        @Override
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        public final Boolean getLicenseCountHardLimit() {
            return this.licenseCountHardLimit;
        }

        @Override
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        public final Collection<String> getLicenseRules() {
            return this.licenseRules;
        }

        @Override
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRules(String ... licenseRules) {
            this.licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<ProductInformation.Builder> getProductInformationList() {
            return this.productInformationList != null ? (Collection)this.productInformationList.stream().map(ProductInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productInformationList(Collection<ProductInformation> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copy(productInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(ProductInformation ... productInformationList) {
            this.productInformationList(Arrays.asList(productInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationList(Consumer<ProductInformation.Builder> ... productInformationList) {
            this.productInformationList(Stream.of(productInformationList).map(c -> (ProductInformation)((ProductInformation.Builder)ProductInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductInformationList(Collection<ProductInformation.BuilderImpl> productInformationList) {
            this.productInformationList = ProductInformationListCopier.copyFromBuilder(productInformationList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseConfigurationRequest build() {
            return new CreateLicenseConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseConfigurationRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder licenseCountingType(String var1);

        public Builder licenseCountingType(LicenseCountingType var1);

        public Builder licenseCount(Long var1);

        public Builder licenseCountHardLimit(Boolean var1);

        public Builder licenseRules(Collection<String> var1);

        public Builder licenseRules(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder productInformationList(Collection<ProductInformation> var1);

        public Builder productInformationList(ProductInformation ... var1);

        public Builder productInformationList(Consumer<ProductInformation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

