/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes product information for a license configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductInformation.Builder, ProductInformation> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProductInformation::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<ProductInformationFilter>> PRODUCT_INFORMATION_FILTER_LIST_FIELD = SdkField
            .<List<ProductInformationFilter>> builder(MarshallingType.LIST)
            .getter(getter(ProductInformation::productInformationFilterList))
            .setter(setter(Builder::productInformationFilterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductInformationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductInformationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            PRODUCT_INFORMATION_FILTER_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final List<ProductInformationFilter> productInformationFilterList;

    private ProductInformation(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.productInformationFilterList = builder.productInformationFilterList;
    }

    /**
     * <p>
     * Resource type. The value is <code>SSM_MANAGED</code>.
     * </p>
     * 
     * @return Resource type. The value is <code>SSM_MANAGED</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * Returns true if the ProductInformationFilterList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasProductInformationFilterList() {
        return productInformationFilterList != null && !(productInformationFilterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Product information filters. The following filters and logical operators are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Application Publisher</code> - The publisher of the application. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
     * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
     * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductInformationFilterList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Product information filters. The following filters and logical operators are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Application Publisher</code> - The publisher of the application. Logical operator is
     *         <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Application Version</code> - The version of the application. Logical operator is
     *         <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code>
     *         and <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
     *         <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
     *         </p>
     *         </li>
     */
    public List<ProductInformationFilter> productInformationFilterList() {
        return productInformationFilterList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(productInformationFilterList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductInformation)) {
            return false;
        }
        ProductInformation other = (ProductInformation) obj;
        return Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(productInformationFilterList(), other.productInformationFilterList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProductInformation").add("ResourceType", resourceType())
                .add("ProductInformationFilterList", productInformationFilterList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ProductInformationFilterList":
            return Optional.ofNullable(clazz.cast(productInformationFilterList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductInformation, T> g) {
        return obj -> g.apply((ProductInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductInformation> {
        /**
         * <p>
         * Resource type. The value is <code>SSM_MANAGED</code>.
         * </p>
         * 
         * @param resourceType
         *        Resource type. The value is <code>SSM_MANAGED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Product information filters. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Publisher</code> - The publisher of the application. Logical operator is
         * <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
         * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param productInformationFilterList
         *        Product information filters. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Publisher</code> - The publisher of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Version</code> - The version of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>License Included</code> - The type of license included. Logical operators are
         *        <code>EQUALS</code> and <code>NOT_EQUALS</code>. Possible values are
         *        <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> |
         *        <code>windows-server-datacenter</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterList(Collection<ProductInformationFilter> productInformationFilterList);

        /**
         * <p>
         * Product information filters. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Publisher</code> - The publisher of the application. Logical operator is
         * <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
         * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param productInformationFilterList
         *        Product information filters. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Publisher</code> - The publisher of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Application Version</code> - The version of the application. Logical operator is
         *        <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>License Included</code> - The type of license included. Logical operators are
         *        <code>EQUALS</code> and <code>NOT_EQUALS</code>. Possible values are
         *        <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> |
         *        <code>windows-server-datacenter</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productInformationFilterList(ProductInformationFilter... productInformationFilterList);

        /**
         * <p>
         * Product information filters. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Application Name</code> - The name of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Publisher</code> - The publisher of the application. Logical operator is
         * <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Application Version</code> - The version of the application. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Name</code> - The name of the platform. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Platform Type</code> - The platform type. Logical operator is <code>EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>License Included</code> - The type of license included. Logical operators are <code>EQUALS</code> and
         * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<ProductInformationFilter>.Builder} avoiding
         * the need to create one manually via {@link List<ProductInformationFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductInformationFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #productInformationFilterList(List<ProductInformationFilter>)}
         * .
         * 
         * @param productInformationFilterList
         *        a consumer that will call methods on {@link List<ProductInformationFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productInformationFilterList(List<ProductInformationFilter>)
         */
        Builder productInformationFilterList(Consumer<ProductInformationFilter.Builder>... productInformationFilterList);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private List<ProductInformationFilter> productInformationFilterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProductInformation model) {
            resourceType(model.resourceType);
            productInformationFilterList(model.productInformationFilterList);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<ProductInformationFilter.Builder> getProductInformationFilterList() {
            return productInformationFilterList != null ? productInformationFilterList.stream()
                    .map(ProductInformationFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productInformationFilterList(Collection<ProductInformationFilter> productInformationFilterList) {
            this.productInformationFilterList = ProductInformationFilterListCopier.copy(productInformationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationFilterList(ProductInformationFilter... productInformationFilterList) {
            productInformationFilterList(Arrays.asList(productInformationFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationFilterList(
                Consumer<ProductInformationFilter.Builder>... productInformationFilterList) {
            productInformationFilterList(Stream.of(productInformationFilterList)
                    .map(c -> ProductInformationFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductInformationFilterList(
                Collection<ProductInformationFilter.BuilderImpl> productInformationFilterList) {
            this.productInformationFilterList = ProductInformationFilterListCopier.copyFromBuilder(productInformationFilterList);
        }

        @Override
        public ProductInformation build() {
            return new ProductInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
