/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductInformationFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductInformationFilter> {
    private static final SdkField<String> PRODUCT_INFORMATION_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductInformationFilter.getter(ProductInformationFilter::productInformationFilterName)).setter(ProductInformationFilter.setter(Builder::productInformationFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterName").build()}).build();
    private static final SdkField<List<String>> PRODUCT_INFORMATION_FILTER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProductInformationFilter.getter(ProductInformationFilter::productInformationFilterValue)).setter(ProductInformationFilter.setter(Builder::productInformationFilterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRODUCT_INFORMATION_FILTER_COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductInformationFilter.getter(ProductInformationFilter::productInformationFilterComparator)).setter(ProductInformationFilter.setter(Builder::productInformationFilterComparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterComparator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_INFORMATION_FILTER_NAME_FIELD, PRODUCT_INFORMATION_FILTER_VALUE_FIELD, PRODUCT_INFORMATION_FILTER_COMPARATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productInformationFilterName;
    private final List<String> productInformationFilterValue;
    private final String productInformationFilterComparator;

    private ProductInformationFilter(BuilderImpl builder) {
        this.productInformationFilterName = builder.productInformationFilterName;
        this.productInformationFilterValue = builder.productInformationFilterValue;
        this.productInformationFilterComparator = builder.productInformationFilterComparator;
    }

    public String productInformationFilterName() {
        return this.productInformationFilterName;
    }

    public List<String> productInformationFilterValue() {
        return this.productInformationFilterValue;
    }

    public String productInformationFilterComparator() {
        return this.productInformationFilterComparator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productInformationFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productInformationFilterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.productInformationFilterComparator());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductInformationFilter)) {
            return false;
        }
        ProductInformationFilter other = (ProductInformationFilter)obj;
        return Objects.equals(this.productInformationFilterName(), other.productInformationFilterName()) && Objects.equals(this.productInformationFilterValue(), other.productInformationFilterValue()) && Objects.equals(this.productInformationFilterComparator(), other.productInformationFilterComparator());
    }

    public String toString() {
        return ToString.builder((String)"ProductInformationFilter").add("ProductInformationFilterName", (Object)this.productInformationFilterName()).add("ProductInformationFilterValue", this.productInformationFilterValue()).add("ProductInformationFilterComparator", (Object)this.productInformationFilterComparator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductInformationFilterName": {
                return Optional.ofNullable(clazz.cast(this.productInformationFilterName()));
            }
            case "ProductInformationFilterValue": {
                return Optional.ofNullable(clazz.cast(this.productInformationFilterValue()));
            }
            case "ProductInformationFilterComparator": {
                return Optional.ofNullable(clazz.cast(this.productInformationFilterComparator()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductInformationFilter, T> g) {
        return obj -> g.apply((ProductInformationFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productInformationFilterName;
        private List<String> productInformationFilterValue = DefaultSdkAutoConstructList.getInstance();
        private String productInformationFilterComparator;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductInformationFilter model) {
            this.productInformationFilterName(model.productInformationFilterName);
            this.productInformationFilterValue(model.productInformationFilterValue);
            this.productInformationFilterComparator(model.productInformationFilterComparator);
        }

        public final String getProductInformationFilterName() {
            return this.productInformationFilterName;
        }

        @Override
        public final Builder productInformationFilterName(String productInformationFilterName) {
            this.productInformationFilterName = productInformationFilterName;
            return this;
        }

        public final void setProductInformationFilterName(String productInformationFilterName) {
            this.productInformationFilterName = productInformationFilterName;
        }

        public final Collection<String> getProductInformationFilterValue() {
            return this.productInformationFilterValue;
        }

        @Override
        public final Builder productInformationFilterValue(Collection<String> productInformationFilterValue) {
            this.productInformationFilterValue = StringListCopier.copy(productInformationFilterValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationFilterValue(String ... productInformationFilterValue) {
            this.productInformationFilterValue(Arrays.asList(productInformationFilterValue));
            return this;
        }

        public final void setProductInformationFilterValue(Collection<String> productInformationFilterValue) {
            this.productInformationFilterValue = StringListCopier.copy(productInformationFilterValue);
        }

        public final String getProductInformationFilterComparator() {
            return this.productInformationFilterComparator;
        }

        @Override
        public final Builder productInformationFilterComparator(String productInformationFilterComparator) {
            this.productInformationFilterComparator = productInformationFilterComparator;
            return this;
        }

        public final void setProductInformationFilterComparator(String productInformationFilterComparator) {
            this.productInformationFilterComparator = productInformationFilterComparator;
        }

        public ProductInformationFilter build() {
            return new ProductInformationFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductInformationFilter> {
        public Builder productInformationFilterName(String var1);

        public Builder productInformationFilterValue(Collection<String> var1);

        public Builder productInformationFilterValue(String ... var1);

        public Builder productInformationFilterComparator(String var1);
    }
}

