/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationStatus;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLicenseConfigurationRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, UpdateLicenseConfigurationRequest> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLicenseConfigurationRequest.getter(UpdateLicenseConfigurationRequest::licenseConfigurationArn)).setter(UpdateLicenseConfigurationRequest.setter(Builder::licenseConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build()}).build();
    private static final SdkField<String> LICENSE_CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLicenseConfigurationRequest.getter(UpdateLicenseConfigurationRequest::licenseConfigurationStatusAsString)).setter(UpdateLicenseConfigurationRequest.setter(Builder::licenseConfigurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationStatus").build()}).build();
    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateLicenseConfigurationRequest.getter(UpdateLicenseConfigurationRequest::licenseRules)).setter(UpdateLicenseConfigurationRequest.setter(Builder::licenseRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UpdateLicenseConfigurationRequest.getter(UpdateLicenseConfigurationRequest::licenseCount)).setter(UpdateLicenseConfigurationRequest.setter(Builder::licenseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()}).build();
    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateLicenseConfigurationRequest.getter(UpdateLicenseConfigurationRequest::licenseCountHardLimit)).setter(UpdateLicenseConfigurationRequest.setter(Builder::licenseCountHardLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLicenseConfigurationRequest.getter(UpdateLicenseConfigurationRequest::name)).setter(UpdateLicenseConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLicenseConfigurationRequest.getter(UpdateLicenseConfigurationRequest::description)).setter(UpdateLicenseConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATION_ARN_FIELD, LICENSE_CONFIGURATION_STATUS_FIELD, LICENSE_RULES_FIELD, LICENSE_COUNT_FIELD, LICENSE_COUNT_HARD_LIMIT_FIELD, NAME_FIELD, DESCRIPTION_FIELD));
    private final String licenseConfigurationArn;
    private final String licenseConfigurationStatus;
    private final List<String> licenseRules;
    private final Long licenseCount;
    private final Boolean licenseCountHardLimit;
    private final String name;
    private final String description;

    private UpdateLicenseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.licenseConfigurationStatus = builder.licenseConfigurationStatus;
        this.licenseRules = builder.licenseRules;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.name = builder.name;
        this.description = builder.description;
    }

    public String licenseConfigurationArn() {
        return this.licenseConfigurationArn;
    }

    public LicenseConfigurationStatus licenseConfigurationStatus() {
        return LicenseConfigurationStatus.fromValue(this.licenseConfigurationStatus);
    }

    public String licenseConfigurationStatusAsString() {
        return this.licenseConfigurationStatus;
    }

    public List<String> licenseRules() {
        return this.licenseRules;
    }

    public Long licenseCount() {
        return this.licenseCount;
    }

    public Boolean licenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLicenseConfigurationRequest)) {
            return false;
        }
        UpdateLicenseConfigurationRequest other = (UpdateLicenseConfigurationRequest)((Object)obj);
        return Objects.equals(this.licenseConfigurationArn(), other.licenseConfigurationArn()) && Objects.equals(this.licenseConfigurationStatusAsString(), other.licenseConfigurationStatusAsString()) && Objects.equals(this.licenseRules(), other.licenseRules()) && Objects.equals(this.licenseCount(), other.licenseCount()) && Objects.equals(this.licenseCountHardLimit(), other.licenseCountHardLimit()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"UpdateLicenseConfigurationRequest").add("LicenseConfigurationArn", (Object)this.licenseConfigurationArn()).add("LicenseConfigurationStatus", (Object)this.licenseConfigurationStatusAsString()).add("LicenseRules", this.licenseRules()).add("LicenseCount", (Object)this.licenseCount()).add("LicenseCountHardLimit", (Object)this.licenseCountHardLimit()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationArn()));
            }
            case "LicenseConfigurationStatus": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationStatusAsString()));
            }
            case "LicenseRules": {
                return Optional.ofNullable(clazz.cast(this.licenseRules()));
            }
            case "LicenseCount": {
                return Optional.ofNullable(clazz.cast(this.licenseCount()));
            }
            case "LicenseCountHardLimit": {
                return Optional.ofNullable(clazz.cast(this.licenseCountHardLimit()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLicenseConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLicenseConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseConfigurationArn;
        private String licenseConfigurationStatus;
        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();
        private Long licenseCount;
        private Boolean licenseCountHardLimit;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLicenseConfigurationRequest model) {
            super(model);
            this.licenseConfigurationArn(model.licenseConfigurationArn);
            this.licenseConfigurationStatus(model.licenseConfigurationStatus);
            this.licenseRules(model.licenseRules);
            this.licenseCount(model.licenseCount);
            this.licenseCountHardLimit(model.licenseCountHardLimit);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getLicenseConfigurationArn() {
            return this.licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        public final String getLicenseConfigurationStatusAsString() {
            return this.licenseConfigurationStatus;
        }

        @Override
        public final Builder licenseConfigurationStatus(String licenseConfigurationStatus) {
            this.licenseConfigurationStatus = licenseConfigurationStatus;
            return this;
        }

        @Override
        public final Builder licenseConfigurationStatus(LicenseConfigurationStatus licenseConfigurationStatus) {
            this.licenseConfigurationStatus(licenseConfigurationStatus == null ? null : licenseConfigurationStatus.toString());
            return this;
        }

        public final void setLicenseConfigurationStatus(String licenseConfigurationStatus) {
            this.licenseConfigurationStatus = licenseConfigurationStatus;
        }

        public final Collection<String> getLicenseRules() {
            return this.licenseRules;
        }

        @Override
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRules(String ... licenseRules) {
            this.licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        public final Long getLicenseCount() {
            return this.licenseCount;
        }

        @Override
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        public final Boolean getLicenseCountHardLimit() {
            return this.licenseCountHardLimit;
        }

        @Override
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLicenseConfigurationRequest build() {
            return new UpdateLicenseConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLicenseConfigurationRequest> {
        public Builder licenseConfigurationArn(String var1);

        public Builder licenseConfigurationStatus(String var1);

        public Builder licenseConfigurationStatus(LicenseConfigurationStatus var1);

        public Builder licenseRules(Collection<String> var1);

        public Builder licenseRules(String ... var1);

        public Builder licenseCount(Long var1);

        public Builder licenseCountHardLimit(Boolean var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

